/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.core.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.inject.Any;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArtemisUtil {
    public static final String DEFAULT_CONFIG_NAME = "<default>";

    private ArtemisUtil() {
    }

    public static boolean isDefault(String configName) {
        return DEFAULT_CONFIG_NAME.equals(configName);
    }

    public static void validateIntegrity(String name, ArtemisRuntimeConfig runtimeConfig, ArtemisBuildTimeConfig buildTimeConfig) {
        boolean devServiceEnabled = buildTimeConfig.getDevservices().isEnabled();
        if (runtimeConfig.getUrl() == null && devServiceEnabled) {
            throw new IllegalStateException(String.format("Configuration %s: url is not set and devservices is activated. This is a bug. Please report it.", name));
        }
        if ((runtimeConfig.isPresent() || buildTimeConfig.isPresent()) && buildTimeConfig.isEnabled() && runtimeConfig.getUrl() == null) {
            throw new IllegalStateException(String.format("Configuration %s: the configuration is enabled, but no URL is configured. Please either disable the configuration or set the URL.", name));
        }
    }

    public static <T> Map<String, T> extractIdentifiers(Class<T> clazz, Set<String> namesToIgnore) {
        HashMap<String, Object> connectionFactoryNamesFromArc = new HashMap<String, Object>();
        for (InstanceHandle handle : Arc.container().listAll(clazz, new Annotation[]{Any.Literal.INSTANCE})) {
            String name = ArtemisUtil.extractIdentifier(handle);
            if (name == null || namesToIgnore.contains(name)) continue;
            connectionFactoryNamesFromArc.put(name, handle.get());
        }
        return connectionFactoryNamesFromArc;
    }

    private static String extractIdentifier(InstanceHandle<?> handle) {
        for (Annotation qualifier : handle.getBean().getQualifiers()) {
            if (!(qualifier instanceof Identifier)) continue;
            Identifier identifier = (Identifier)qualifier;
            return identifier.value();
        }
        return null;
    }
}

