/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.DefaultHttpConnectionFactory;
import io.prometheus.client.exporter.HttpConnectionFactory;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class PushGateway {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    protected final String gatewayBaseURL;
    private HttpConnectionFactory connectionFactory = new DefaultHttpConnectionFactory();

    public PushGateway(String address) {
        this(PushGateway.createURLSneakily("http://" + address));
    }

    public PushGateway(URL serverBaseURL) {
        this.gatewayBaseURL = URI.create(serverBaseURL.toString() + "/metrics/job/").normalize().toString();
    }

    public void setConnectionFactory(HttpConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private static URL createURLSneakily(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void push(CollectorRegistry registry, String job) throws IOException {
        this.doRequest(registry, job, null, "PUT");
    }

    public void push(Collector collector, String job) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job);
    }

    public void push(CollectorRegistry registry, String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(registry, job, groupingKey, "PUT");
    }

    public void push(Collector collector, String job, Map<String, String> groupingKey) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.push(registry, job, groupingKey);
    }

    public void pushAdd(CollectorRegistry registry, String job) throws IOException {
        this.doRequest(registry, job, null, "POST");
    }

    public void pushAdd(Collector collector, String job) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job);
    }

    public void pushAdd(CollectorRegistry registry, String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(registry, job, groupingKey, "POST");
    }

    public void pushAdd(Collector collector, String job, Map<String, String> groupingKey) throws IOException {
        CollectorRegistry registry = new CollectorRegistry();
        collector.register(registry);
        this.pushAdd(registry, job, groupingKey);
    }

    public void delete(String job) throws IOException {
        this.doRequest(null, job, null, "DELETE");
    }

    public void delete(String job, Map<String, String> groupingKey) throws IOException {
        this.doRequest(null, job, groupingKey, "DELETE");
    }

    @Deprecated
    public void push(CollectorRegistry registry, String job, String instance) throws IOException {
        this.push(registry, job, Collections.singletonMap("instance", instance));
    }

    @Deprecated
    public void push(Collector collector, String job, String instance) throws IOException {
        this.push(collector, job, Collections.singletonMap("instance", instance));
    }

    @Deprecated
    public void pushAdd(CollectorRegistry registry, String job, String instance) throws IOException {
        this.pushAdd(registry, job, Collections.singletonMap("instance", instance));
    }

    @Deprecated
    public void pushAdd(Collector collector, String job, String instance) throws IOException {
        this.pushAdd(collector, job, Collections.singletonMap("instance", instance));
    }

    @Deprecated
    public void delete(String job, String instance) throws IOException {
        this.delete(job, Collections.singletonMap("instance", instance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRequest(CollectorRegistry registry, String job, Map<String, String> groupingKey, String method) throws IOException {
        String url = this.gatewayBaseURL + URLEncoder.encode(job, "UTF-8");
        if (groupingKey != null) {
            for (Map.Entry<String, String> entry : groupingKey.entrySet()) {
                url = url + "/" + entry.getKey() + "/" + URLEncoder.encode(entry.getValue(), "UTF-8");
            }
        }
        HttpURLConnection connection = this.connectionFactory.create(url);
        connection.setRequestProperty("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
        if (!method.equals("DELETE")) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(method);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.connect();
        try {
            int response;
            if (!method.equals("DELETE")) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                TextFormat.write004((Writer)writer, (Enumeration)registry.metricFamilySamples());
                writer.flush();
                writer.close();
            }
            if ((response = connection.getResponseCode()) != 202) {
                throw new IOException("Response code from " + url + " was " + response);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static Map<String, String> instanceIPGroupingKey() throws UnknownHostException {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        groupingKey.put("instance", InetAddress.getLocalHost().getHostAddress());
        return groupingKey;
    }
}

