/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.publisher;

import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.bus.Bus;
import reactor.bus.EventBus;
import reactor.bus.registry.Registration;
import reactor.bus.selector.Selector;
import reactor.core.dispatch.SynchronousDispatcher;
import reactor.core.reactivestreams.SerializedSubscriber;
import reactor.fn.Consumer;

public final class BusPublisher<T>
implements Publisher<T> {
    private final Selector selector;
    private final Bus<T> observable;
    private final boolean ordering;

    public BusPublisher(@Nonnull Bus<T> observable, @Nonnull Selector selector) {
        this.selector = selector;
        this.observable = observable;
        SynchronousDispatcher dispatcher = EventBus.class.isAssignableFrom(observable.getClass()) ? ((EventBus)observable).getDispatcher() : SynchronousDispatcher.INSTANCE;
        this.ordering = dispatcher.supportsOrdering();
    }

    public void subscribe(Subscriber<? super T> s) {
        SerializedSubscriber subscriber = !this.ordering ? SerializedSubscriber.create(s) : s;
        subscriber.onSubscribe(new Subscription((Subscriber)subscriber){
            final Registration<Object, Consumer<? extends T>> registration;
            final /* synthetic */ Subscriber val$subscriber;
            {
                this.val$subscriber = subscriber;
                this.registration = BusPublisher.this.observable.on(BusPublisher.this.selector, new Consumer<T>(){

                    public void accept(T event) {
                        val$subscriber.onNext(event);
                    }
                });
            }

            public void request(long n) {
            }

            public void cancel() {
                this.registration.cancel();
            }
        });
    }

    public String toString() {
        return "BusPublisher{selector=" + this.selector + ", bus=" + this.observable + '}';
    }
}

