/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.LoopResources;
import reactor.netty.udp.UdpClientBootstrap;
import reactor.netty.udp.UdpClientConnect;
import reactor.netty.udp.UdpClientDoOn;
import reactor.netty.udp.UdpClientObserve;
import reactor.netty.udp.UdpClientRunOn;
import reactor.netty.udp.UdpInbound;
import reactor.netty.udp.UdpOperations;
import reactor.netty.udp.UdpOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class UdpClient {
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    static final Bootstrap DEFAULT_BOOTSTRAP = ((Bootstrap)new Bootstrap().option(ChannelOption.AUTO_READ, (Object)false)).remoteAddress(NetUtil.LOCALHOST, DEFAULT_PORT);
    static final LoggingHandler LOGGING_HANDLER;
    static final Logger log;

    public static UdpClient create() {
        return UdpClientConnect.INSTANCE;
    }

    public final UdpClient addressSupplier(Supplier<? extends SocketAddress> connectingAddressSupplier) {
        Objects.requireNonNull(connectingAddressSupplier, "connectingAddressSupplier");
        return this.bootstrap(b -> b.remoteAddress((SocketAddress)connectingAddressSupplier.get()));
    }

    public final <T> UdpClient attr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.attr(key, value));
    }

    public final UdpClient bootstrap(Function<? super Bootstrap, ? extends Bootstrap> bootstrapMapper) {
        return new UdpClientBootstrap(this, bootstrapMapper);
    }

    public final Mono<? extends Connection> connect() {
        Bootstrap b;
        try {
            b = this.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal((Throwable)t);
            return Mono.error((Throwable)t);
        }
        return this.connect(b);
    }

    public final Connection connectNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull((Connection)this.connect().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("UdpClient couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final UdpClient doOnConnect(Consumer<? super Bootstrap> doOnConnect) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        return new UdpClientDoOn(this, doOnConnect, null, null);
    }

    public final UdpClient doOnConnected(Consumer<? super Connection> doOnConnected) {
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        return new UdpClientDoOn(this, null, doOnConnected, null);
    }

    public final UdpClient doOnDisconnected(Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new UdpClientDoOn(this, null, null, doOnDisconnected);
    }

    public final UdpClient doOnLifecycle(Consumer<? super Bootstrap> doOnConnect, Consumer<? super Connection> doOnConnected, Consumer<? super Connection> doOnDisconnected) {
        Objects.requireNonNull(doOnConnect, "doOnConnect");
        Objects.requireNonNull(doOnConnected, "doOnConnected");
        Objects.requireNonNull(doOnDisconnected, "doOnDisconnected");
        return new UdpClientDoOn(this, doOnConnect, doOnConnected, doOnDisconnected);
    }

    public final UdpClient host(String host) {
        Objects.requireNonNull(host, "host");
        return this.bootstrap(b -> b.remoteAddress(host, UdpClient.getPort(b)));
    }

    public final UdpClient handle(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.doOnConnected(c -> {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c.channel(), "Handler is being applied: {}"), new Object[]{handler});
            }
            Mono.fromDirect((Publisher)((Publisher)handler.apply((UdpInbound)((Object)c), (UdpOutbound)((Object)c)))).subscribe(c.disposeSubscriber());
        });
    }

    public final UdpClient observe(ConnectionObserver observer) {
        return new UdpClientObserve(this, observer);
    }

    public final <T> UdpClient option(ChannelOption<T> key, T value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        return this.bootstrap(b -> (Bootstrap)b.option(key, value));
    }

    public final UdpClient port(int port) {
        return this.bootstrap(b -> b.remoteAddress(UdpClient.getHost(b), port));
    }

    public final UdpClient runOn(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.runOn((boolean preferNative) -> eventLoopGroup);
    }

    public final UdpClient runOn(LoopResources channelResources) {
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public final UdpClient runOn(LoopResources channelResources, boolean preferNative) {
        return new UdpClientRunOn(this, channelResources, preferNative, null);
    }

    public final UdpClient runOn(LoopResources channelResources, InternetProtocolFamily family) {
        return new UdpClientRunOn(this, channelResources, false, family);
    }

    public final UdpClient wiretap(boolean enable) {
        if (enable) {
            return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
        }
        return this.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "reactor.left.loggingHandler"));
    }

    public final UdpClient wiretap(String category) {
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public final UdpClient wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, new LoggingHandler(category, level)));
    }

    protected Bootstrap configure() {
        return DEFAULT_BOOTSTRAP.clone();
    }

    protected abstract Mono<? extends Connection> connect(Bootstrap var1);

    static String getHost(Bootstrap b) {
        if (b.config().remoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().remoteAddress()).getHostString();
        }
        return NetUtil.LOCALHOST.getHostAddress();
    }

    static int getPort(Bootstrap b) {
        if (b.config().remoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)b.config().remoteAddress()).getPort();
        }
        return DEFAULT_PORT;
    }

    static {
        BootstrapHandlers.channelOperationFactory(DEFAULT_BOOTSTRAP, (ch, c, msg) -> new UdpOperations(ch, c));
        LOGGING_HANDLER = new LoggingHandler(UdpClient.class);
        log = Loggers.getLogger(UdpClient.class);
    }
}

