/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerOperations;

final class HttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    Timer.Sample dataReceivedTimeSample;
    Timer.Sample dataSentTimeSample;
    final MeterRegistry registry;
    final String name;
    final Timer.Builder dataReceivedTimeBuilder;
    final Timer.Builder dataSentTimeBuilder;
    final Timer.Builder responseTimeBuilder;
    String uri;
    String method;

    HttpServerMetricsHandler(MeterRegistry registry, String name) {
        this.registry = registry;
        this.name = name;
        this.dataReceivedTimeBuilder = Timer.builder((String)(name + ".data.received.time")).description("Time that is spent in consuming incoming data");
        this.dataSentTimeBuilder = Timer.builder((String)(name + ".data.sent.time")).description("Time that is spent in sending outgoing data");
        this.responseTimeBuilder = Timer.builder((String)(name + ".response.time")).description("Total time for the request/response");
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTimeSample = Timer.start((MeterRegistry)this.registry);
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    this.dataSentTimeSample.stop(this.dataSentTimeBuilder.tags(new String[]{"uri", ops.uri(), "method", ops.method().name(), "status", ops.status().codeAsText().toString()}).register(this.registry));
                    Timer responseTime = this.responseTimeBuilder.tags(new String[]{"uri", ops.uri(), "method", ops.method().name(), "status", ops.status().codeAsText().toString()}).register(this.registry);
                    if (this.dataReceivedTimeSample != null) {
                        this.dataReceivedTimeSample.stop(responseTime);
                    } else {
                        this.dataSentTimeSample.stop(responseTime);
                    }
                    DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tags(new String[]{"remote.address", ops.remoteAddress().getHostString(), "uri", ops.uri()}).register(this.registry).record((double)this.dataSent);
                    this.dataSent = 0L;
                }
            });
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.dataReceivedTimeSample = Timer.start((MeterRegistry)this.registry);
            HttpRequest request = (HttpRequest)msg;
            this.uri = request.uri();
            this.method = request.method().name();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            Timer dataReceivedTime = this.dataReceivedTimeBuilder.tags(new String[]{"uri", this.uri, "method", this.method}).register(this.registry);
            this.dataReceivedTimeSample.stop(dataReceivedTime);
            DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tags(new String[]{"remote.address", this.address(ctx), "uri", this.uri}).register(this.registry).record((double)this.dataReceived);
            this.dataReceived = 0L;
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.uri != null) {
            Counter.builder((String)(this.name + ".errors")).description("Number of the errors that are occurred").tags(new String[]{"remote.address", this.address(ctx), "uri", this.uri}).register(this.registry).increment();
        }
        super.exceptionCaught(ctx, cause);
    }

    String address(ChannelHandlerContext ctx) {
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getHostString();
        }
        return socketAddress.toString();
    }
}

