/*
 * Pinecone Control Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: v1
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.openapitools.client.JSON;

/**
 * Configuration for the behavior of Pinecone&#39;s internal metadata index. By default, all metadata is indexed; when &#x60;metadata_config&#x60; is present, only specified metadata fields are indexed. These configurations are only valid for use with pod indexes.
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-05T14:30:53.594301-05:00[America/New_York]")
public class PodSpecMetadataConfig {
  public static final String SERIALIZED_NAME_INDEXED = "indexed";
  @SerializedName(SERIALIZED_NAME_INDEXED)
  private List<String> indexed;

  public PodSpecMetadataConfig() {
  }

  public PodSpecMetadataConfig indexed(List<String> indexed) {
    
    this.indexed = indexed;
    return this;
  }

  public PodSpecMetadataConfig addIndexedItem(String indexedItem) {
    if (this.indexed == null) {
      this.indexed = new ArrayList<>();
    }
    this.indexed.add(indexedItem);
    return this;
  }

   /**
   * By default, all metadata is indexed; to change this behavior, use this property to specify an array of metadata fields which should be indexed.
   * @return indexed
  **/
  @javax.annotation.Nullable
  public List<String> getIndexed() {
    return indexed;
  }


  public void setIndexed(List<String> indexed) {
    this.indexed = indexed;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PodSpecMetadataConfig podSpecMetadataConfig = (PodSpecMetadataConfig) o;
    return Objects.equals(this.indexed, podSpecMetadataConfig.indexed);
  }

  @Override
  public int hashCode() {
    return Objects.hash(indexed);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PodSpecMetadataConfig {\n");
    sb.append("    indexed: ").append(toIndentedString(indexed)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("indexed");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to PodSpecMetadataConfig
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!PodSpecMetadataConfig.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PodSpecMetadataConfig is not found in the empty JSON string", PodSpecMetadataConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PodSpecMetadataConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodSpecMetadataConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the optional json data is an array if present
      if (jsonObj.get("indexed") != null && !jsonObj.get("indexed").isJsonNull() && !jsonObj.get("indexed").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `indexed` to be an array in the JSON string but got `%s`", jsonObj.get("indexed").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PodSpecMetadataConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PodSpecMetadataConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PodSpecMetadataConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PodSpecMetadataConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<PodSpecMetadataConfig>() {
           @Override
           public void write(JsonWriter out, PodSpecMetadataConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PodSpecMetadataConfig read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PodSpecMetadataConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PodSpecMetadataConfig
  * @throws IOException if the JSON string is invalid with respect to PodSpecMetadataConfig
  */
  public static PodSpecMetadataConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PodSpecMetadataConfig.class);
  }

 /**
  * Convert an instance of PodSpecMetadataConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

