/*
 * Pinecone Control Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: v1
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.openapitools.client.JSON;

/**
 * ConfigureIndexRequestSpecPod
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-05T14:30:53.594301-05:00[America/New_York]")
public class ConfigureIndexRequestSpecPod {
  public static final String SERIALIZED_NAME_REPLICAS = "replicas";
  @SerializedName(SERIALIZED_NAME_REPLICAS)
  private Integer replicas = 1;

  public static final String SERIALIZED_NAME_POD_TYPE = "pod_type";
  @SerializedName(SERIALIZED_NAME_POD_TYPE)
  private String podType = "p1.x1";

  public ConfigureIndexRequestSpecPod() {
  }

  public ConfigureIndexRequestSpecPod replicas(Integer replicas) {
    
    this.replicas = replicas;
    return this;
  }

   /**
   * The number of replicas. Replicas duplicate your index. They provide higher availability and throughput. Replicas can be scaled up or down as your needs change.
   * minimum: 1
   * @return replicas
  **/
  @javax.annotation.Nullable
  public Integer getReplicas() {
    return replicas;
  }


  public void setReplicas(Integer replicas) {
    this.replicas = replicas;
  }


  public ConfigureIndexRequestSpecPod podType(String podType) {
    
    this.podType = podType;
    return this;
  }

   /**
   * The type of pod to use. One of &#x60;s1&#x60;, &#x60;p1&#x60;, or &#x60;p2&#x60; appended with &#x60;.&#x60; and one of &#x60;x1&#x60;, &#x60;x2&#x60;, &#x60;x4&#x60;, or &#x60;x8&#x60;.
   * @return podType
  **/
  @javax.annotation.Nullable
  public String getPodType() {
    return podType;
  }


  public void setPodType(String podType) {
    this.podType = podType;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConfigureIndexRequestSpecPod configureIndexRequestSpecPod = (ConfigureIndexRequestSpecPod) o;
    return Objects.equals(this.replicas, configureIndexRequestSpecPod.replicas) &&
        Objects.equals(this.podType, configureIndexRequestSpecPod.podType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(replicas, podType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConfigureIndexRequestSpecPod {\n");
    sb.append("    replicas: ").append(toIndentedString(replicas)).append("\n");
    sb.append("    podType: ").append(toIndentedString(podType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("replicas");
    openapiFields.add("pod_type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Element and throws an exception if issues found
  *
  * @param jsonElement JSON Element
  * @throws IOException if the JSON Element is invalid with respect to ConfigureIndexRequestSpecPod
  */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!ConfigureIndexRequestSpecPod.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in ConfigureIndexRequestSpecPod is not found in the empty JSON string", ConfigureIndexRequestSpecPod.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!ConfigureIndexRequestSpecPod.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ConfigureIndexRequestSpecPod` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("pod_type") != null && !jsonObj.get("pod_type").isJsonNull()) && !jsonObj.get("pod_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pod_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pod_type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ConfigureIndexRequestSpecPod.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ConfigureIndexRequestSpecPod' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ConfigureIndexRequestSpecPod> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ConfigureIndexRequestSpecPod.class));

       return (TypeAdapter<T>) new TypeAdapter<ConfigureIndexRequestSpecPod>() {
           @Override
           public void write(JsonWriter out, ConfigureIndexRequestSpecPod value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ConfigureIndexRequestSpecPod read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ConfigureIndexRequestSpecPod given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ConfigureIndexRequestSpecPod
  * @throws IOException if the JSON string is invalid with respect to ConfigureIndexRequestSpecPod
  */
  public static ConfigureIndexRequestSpecPod fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ConfigureIndexRequestSpecPod.class);
  }

 /**
  * Convert an instance of ConfigureIndexRequestSpecPod to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

