/*
 * Pinecone Control Plane API
 * Pinecone is a vector database that makes it easy to search and retrieve billions of high-dimensional vectors.
 *
 * The version of the OpenAPI document: v1
 * Contact: support@pinecone.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client.api;

import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.ProgressRequestBody;
import org.openapitools.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.openapitools.client.model.CollectionList;
import org.openapitools.client.model.CollectionModel;
import org.openapitools.client.model.ConfigureIndexRequest;
import org.openapitools.client.model.CreateCollectionRequest;
import org.openapitools.client.model.CreateIndexRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.IndexList;
import org.openapitools.client.model.IndexModel;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManageIndexesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ManageIndexesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManageIndexesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for configureIndex
     * @param indexName The name of the index to configure (required)
     * @param configureIndexRequest The desired pod type and replica configuration for the index. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to configure the index has been accepted. Check the  index status to see when the change has been applied. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call configureIndexCall(String indexName, ConfigureIndexRequest configureIndexRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = configureIndexRequest;

        // create path and map variables
        String localVarPath = "/indexes/{index_name}"
            .replace("{" + "index_name" + "}", localVarApiClient.escapeString(indexName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call configureIndexValidateBeforeCall(String indexName, ConfigureIndexRequest configureIndexRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'indexName' is set
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling configureIndex(Async)");
        }

        // verify the required parameter 'configureIndexRequest' is set
        if (configureIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'configureIndexRequest' when calling configureIndex(Async)");
        }

        return configureIndexCall(indexName, configureIndexRequest, _callback);

    }

    /**
     * 
     * This operation specifies the pod type and number of replicas for an index.
     * @param indexName The name of the index to configure (required)
     * @param configureIndexRequest The desired pod type and replica configuration for the index. (required)
     * @return IndexModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to configure the index has been accepted. Check the  index status to see when the change has been applied. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public IndexModel configureIndex(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = configureIndexWithHttpInfo(indexName, configureIndexRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * This operation specifies the pod type and number of replicas for an index.
     * @param indexName The name of the index to configure (required)
     * @param configureIndexRequest The desired pod type and replica configuration for the index. (required)
     * @return ApiResponse&lt;IndexModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to configure the index has been accepted. Check the  index status to see when the change has been applied. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IndexModel> configureIndexWithHttpInfo(String indexName, ConfigureIndexRequest configureIndexRequest) throws ApiException {
        okhttp3.Call localVarCall = configureIndexValidateBeforeCall(indexName, configureIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation specifies the pod type and number of replicas for an index.
     * @param indexName The name of the index to configure (required)
     * @param configureIndexRequest The desired pod type and replica configuration for the index. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to configure the index has been accepted. Check the  index status to see when the change has been applied. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call configureIndexAsync(String indexName, ConfigureIndexRequest configureIndexRequest, final ApiCallback<IndexModel> _callback) throws ApiException {

        okhttp3.Call localVarCall = configureIndexValidateBeforeCall(indexName, configureIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createCollection
     * @param createCollectionRequest The desired configuration for the collection. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The collection has been successfully created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your collections quota. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A collection already exists with the name provided. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCollectionCall(CreateCollectionRequest createCollectionRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createCollectionRequest;

        // create path and map variables
        String localVarPath = "/collections";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCollectionValidateBeforeCall(CreateCollectionRequest createCollectionRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createCollectionRequest' is set
        if (createCollectionRequest == null) {
            throw new ApiException("Missing the required parameter 'createCollectionRequest' when calling createCollection(Async)");
        }

        return createCollectionCall(createCollectionRequest, _callback);

    }

    /**
     * 
     * This operation creates a Pinecone collection.
     * @param createCollectionRequest The desired configuration for the collection. (required)
     * @return CollectionModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The collection has been successfully created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your collections quota. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A collection already exists with the name provided. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public CollectionModel createCollection(CreateCollectionRequest createCollectionRequest) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = createCollectionWithHttpInfo(createCollectionRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * This operation creates a Pinecone collection.
     * @param createCollectionRequest The desired configuration for the collection. (required)
     * @return ApiResponse&lt;CollectionModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The collection has been successfully created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your collections quota. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A collection already exists with the name provided. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CollectionModel> createCollectionWithHttpInfo(CreateCollectionRequest createCollectionRequest) throws ApiException {
        okhttp3.Call localVarCall = createCollectionValidateBeforeCall(createCollectionRequest, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation creates a Pinecone collection.
     * @param createCollectionRequest The desired configuration for the collection. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The collection has been successfully created. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your collections quota. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> A collection already exists with the name provided. </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCollectionAsync(CreateCollectionRequest createCollectionRequest, final ApiCallback<CollectionModel> _callback) throws ApiException {

        okhttp3.Call localVarCall = createCollectionValidateBeforeCall(createCollectionRequest, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createIndex
     * @param createIndexRequest The desired configuration for the index. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The index has been successfully created </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Unknown cloud or region when creating a serverless index </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Index of given name already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createIndexCall(CreateIndexRequest createIndexRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = createIndexRequest;

        // create path and map variables
        String localVarPath = "/indexes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createIndexValidateBeforeCall(CreateIndexRequest createIndexRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createIndexRequest' is set
        if (createIndexRequest == null) {
            throw new ApiException("Missing the required parameter 'createIndexRequest' when calling createIndex(Async)");
        }

        return createIndexCall(createIndexRequest, _callback);

    }

    /**
     * 
     * This operation deploys a Pinecone index. This is where you specify the measure of similarity, the dimension of vectors to be stored in the index, which cloud provider you would like to deploy with, and more.
     * @param createIndexRequest The desired configuration for the index. (required)
     * @return IndexModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The index has been successfully created </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Unknown cloud or region when creating a serverless index </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Index of given name already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public IndexModel createIndex(CreateIndexRequest createIndexRequest) throws ApiException {
        ApiResponse<IndexModel> localVarResp = createIndexWithHttpInfo(createIndexRequest);
        return localVarResp.getData();
    }

    /**
     * 
     * This operation deploys a Pinecone index. This is where you specify the measure of similarity, the dimension of vectors to be stored in the index, which cloud provider you would like to deploy with, and more.
     * @param createIndexRequest The desired configuration for the index. (required)
     * @return ApiResponse&lt;IndexModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The index has been successfully created </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Unknown cloud or region when creating a serverless index </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Index of given name already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IndexModel> createIndexWithHttpInfo(CreateIndexRequest createIndexRequest) throws ApiException {
        okhttp3.Call localVarCall = createIndexValidateBeforeCall(createIndexRequest, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation deploys a Pinecone index. This is where you specify the measure of similarity, the dimension of vectors to be stored in the index, which cloud provider you would like to deploy with, and more.
     * @param createIndexRequest The desired configuration for the index. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The index has been successfully created </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad request. The request body included invalid request parameters. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> You&#39;ve exceed your pod quota. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Unknown cloud or region when creating a serverless index </td><td>  -  </td></tr>
        <tr><td> 422 </td><td> Unprocessable entity. The request body could not be deserialized. </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Index of given name already exists. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createIndexAsync(CreateIndexRequest createIndexRequest, final ApiCallback<IndexModel> _callback) throws ApiException {

        okhttp3.Call localVarCall = createIndexValidateBeforeCall(createIndexRequest, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteCollection
     * @param collectionName The name of the collection (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The index has been successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCollectionCall(String collectionName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/collections/{collection_name}"
            .replace("{" + "collection_name" + "}", localVarApiClient.escapeString(collectionName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain",
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteCollectionValidateBeforeCall(String collectionName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'collectionName' is set
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling deleteCollection(Async)");
        }

        return deleteCollectionCall(collectionName, _callback);

    }

    /**
     * 
     * This operation deletes an existing collection.
     * @param collectionName The name of the collection (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The index has been successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public String deleteCollection(String collectionName) throws ApiException {
        ApiResponse<String> localVarResp = deleteCollectionWithHttpInfo(collectionName);
        return localVarResp.getData();
    }

    /**
     * 
     * This operation deletes an existing collection.
     * @param collectionName The name of the collection (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The index has been successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> deleteCollectionWithHttpInfo(String collectionName) throws ApiException {
        okhttp3.Call localVarCall = deleteCollectionValidateBeforeCall(collectionName, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation deletes an existing collection.
     * @param collectionName The name of the collection (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The index has been successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteCollectionAsync(String collectionName, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteCollectionValidateBeforeCall(collectionName, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteIndex
     * @param indexName The name of the index to delete (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to delete the index has been accepted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> There is a pending collection created from this index. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteIndexCall(String indexName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/indexes/{index_name}"
            .replace("{" + "index_name" + "}", localVarApiClient.escapeString(indexName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteIndexValidateBeforeCall(String indexName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'indexName' is set
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling deleteIndex(Async)");
        }

        return deleteIndexCall(indexName, _callback);

    }

    /**
     * 
     * This operation deletes an existing index.
     * @param indexName The name of the index to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to delete the index has been accepted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> There is a pending collection created from this index. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public void deleteIndex(String indexName) throws ApiException {
        deleteIndexWithHttpInfo(indexName);
    }

    /**
     * 
     * This operation deletes an existing index.
     * @param indexName The name of the index to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to delete the index has been accepted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> There is a pending collection created from this index. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteIndexWithHttpInfo(String indexName) throws ApiException {
        okhttp3.Call localVarCall = deleteIndexValidateBeforeCall(indexName, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * This operation deletes an existing index.
     * @param indexName The name of the index to delete (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 202 </td><td> The request to delete the index has been accepted. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 412 </td><td> There is a pending collection created from this index. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteIndexAsync(String indexName, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteIndexValidateBeforeCall(indexName, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for describeCollection
     * @param collectionName The name of the collection to be described (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and status of the collection </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeCollectionCall(String collectionName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/collections/{collection_name}"
            .replace("{" + "collection_name" + "}", localVarApiClient.escapeString(collectionName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call describeCollectionValidateBeforeCall(String collectionName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'collectionName' is set
        if (collectionName == null) {
            throw new ApiException("Missing the required parameter 'collectionName' when calling describeCollection(Async)");
        }

        return describeCollectionCall(collectionName, _callback);

    }

    /**
     * 
     * This operation gets a description of a collection.
     * @param collectionName The name of the collection to be described (required)
     * @return CollectionModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and status of the collection </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public CollectionModel describeCollection(String collectionName) throws ApiException {
        ApiResponse<CollectionModel> localVarResp = describeCollectionWithHttpInfo(collectionName);
        return localVarResp.getData();
    }

    /**
     * 
     * This operation gets a description of a collection.
     * @param collectionName The name of the collection to be described (required)
     * @return ApiResponse&lt;CollectionModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and status of the collection </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CollectionModel> describeCollectionWithHttpInfo(String collectionName) throws ApiException {
        okhttp3.Call localVarCall = describeCollectionValidateBeforeCall(collectionName, null);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation gets a description of a collection.
     * @param collectionName The name of the collection to be described (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and status of the collection </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Collection not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeCollectionAsync(String collectionName, final ApiCallback<CollectionModel> _callback) throws ApiException {

        okhttp3.Call localVarCall = describeCollectionValidateBeforeCall(collectionName, _callback);
        Type localVarReturnType = new TypeToken<CollectionModel>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for describeIndex
     * @param indexName The name of the index to be described (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and deployment status of the index </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeIndexCall(String indexName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/indexes/{index_name}"
            .replace("{" + "index_name" + "}", localVarApiClient.escapeString(indexName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call describeIndexValidateBeforeCall(String indexName, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'indexName' is set
        if (indexName == null) {
            throw new ApiException("Missing the required parameter 'indexName' when calling describeIndex(Async)");
        }

        return describeIndexCall(indexName, _callback);

    }

    /**
     * 
     * Get a description of an index.
     * @param indexName The name of the index to be described (required)
     * @return IndexModel
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and deployment status of the index </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public IndexModel describeIndex(String indexName) throws ApiException {
        ApiResponse<IndexModel> localVarResp = describeIndexWithHttpInfo(indexName);
        return localVarResp.getData();
    }

    /**
     * 
     * Get a description of an index.
     * @param indexName The name of the index to be described (required)
     * @return ApiResponse&lt;IndexModel&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and deployment status of the index </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IndexModel> describeIndexWithHttpInfo(String indexName) throws ApiException {
        okhttp3.Call localVarCall = describeIndexValidateBeforeCall(indexName, null);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get a description of an index.
     * @param indexName The name of the index to be described (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Configuration information and deployment status of the index </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Index not found </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call describeIndexAsync(String indexName, final ApiCallback<IndexModel> _callback) throws ApiException {

        okhttp3.Call localVarCall = describeIndexValidateBeforeCall(indexName, _callback);
        Type localVarReturnType = new TypeToken<IndexModel>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listCollections
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the collections in your current project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCollectionsCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/collections";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCollectionsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return listCollectionsCall(_callback);

    }

    /**
     * 
     * This operation returns a list of your Pinecone collections.
     * @return CollectionList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the collections in your current project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public CollectionList listCollections() throws ApiException {
        ApiResponse<CollectionList> localVarResp = listCollectionsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * This operation returns a list of your Pinecone collections.
     * @return ApiResponse&lt;CollectionList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the collections in your current project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CollectionList> listCollectionsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listCollectionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation returns a list of your Pinecone collections.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the collections in your current project. </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCollectionsAsync(final ApiCallback<CollectionList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listCollectionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CollectionList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listIndexes
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the indexes that you have previously created, and which are associated with the given project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIndexesCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] { "https://api.pinecone.io" };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/indexes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listIndexesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return listIndexesCall(_callback);

    }

    /**
     * 
     * This operation returns a list of your Pinecone indexes.
     * @return IndexList
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the indexes that you have previously created, and which are associated with the given project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public IndexList listIndexes() throws ApiException {
        ApiResponse<IndexList> localVarResp = listIndexesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * This operation returns a list of your Pinecone indexes.
     * @return ApiResponse&lt;IndexList&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the indexes that you have previously created, and which are associated with the given project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IndexList> listIndexesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listIndexesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * This operation returns a list of your Pinecone indexes.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This operation returns a list of all the indexes that you have previously created, and which are associated with the given project </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized. Possible causes: Invalid API key. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listIndexesAsync(final ApiCallback<IndexList> _callback) throws ApiException {

        okhttp3.Call localVarCall = listIndexesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<IndexList>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
