/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc.parser;

import io.opentracing.contrib.jdbc.ConnectionInfo;
import io.opentracing.contrib.jdbc.parser.ConnectionURLParser;
import io.opentracing.contrib.jdbc.parser.H2URLParser;
import io.opentracing.contrib.jdbc.parser.MariadbURLParser;
import io.opentracing.contrib.jdbc.parser.MysqlURLParser;
import io.opentracing.contrib.jdbc.parser.OracleURLParser;
import io.opentracing.contrib.jdbc.parser.PostgreSQLURLParser;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLParser {
    private static final Logger log = Logger.getLogger(URLParser.class.getName());
    private static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql";
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle";
    private static final String H2_JDBC_URL_PREFIX = "jdbc:h2";
    private static final String POSTGRESQL_JDBC_URL_PREFIX = "jdbc:postgresql";
    private static final String MARIADB_JDBC_URL_PREFIX = "jdbc:mariadb";
    private static final Map<String, ConnectionURLParser> parserRegister = new LinkedHashMap<String, ConnectionURLParser>();

    public static ConnectionInfo parser(String url) {
        if (null == url) {
            return ConnectionInfo.UNKNOWN_CONNECTION_INFO;
        }
        String lowerCaseUrl = url.toLowerCase();
        ConnectionURLParser parser = URLParser.findURLParser(lowerCaseUrl);
        if (parser == null) {
            return ConnectionInfo.UNKNOWN_CONNECTION_INFO;
        }
        try {
            return parser.parse(url);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error occurs when paring jdbc url");
            return ConnectionInfo.UNKNOWN_CONNECTION_INFO;
        }
    }

    private static ConnectionURLParser findURLParser(String lowerCaseUrl) {
        for (Map.Entry<String, ConnectionURLParser> entry : parserRegister.entrySet()) {
            if (!lowerCaseUrl.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void registerConnectionParser(String urlPrefix, ConnectionURLParser parser) {
        if (null == urlPrefix || parser == null) {
            throw new IllegalArgumentException("urlPrefix and parser can not be null");
        }
        parserRegister.put(urlPrefix.toLowerCase(), parser);
    }

    static {
        parserRegister.put(MYSQL_JDBC_URL_PREFIX, new MysqlURLParser());
        parserRegister.put(ORACLE_JDBC_URL_PREFIX, new OracleURLParser());
        parserRegister.put(H2_JDBC_URL_PREFIX, new H2URLParser());
        parserRegister.put(POSTGRESQL_JDBC_URL_PREFIX, new PostgreSQLURLParser());
        parserRegister.put(MARIADB_JDBC_URL_PREFIX, new MariadbURLParser());
    }
}

