/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.logging.LoggingMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusCollector;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReaderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    static void configureExporter(String name, ConfigProperties config, SdkMeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                MetricExporterConfiguration.configureOtlpMetrics(config, meterProvider);
                return;
            }
            case "prometheus": {
                MetricExporterConfiguration.configurePrometheusMetrics(config, meterProvider);
                return;
            }
            case "logging": {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
                MetricExporterConfiguration.configureLoggingMetrics(config, meterProvider);
                return;
            }
            case "none": {
                return;
            }
        }
        MetricExporter spiExporter = MetricExporterConfiguration.configureSpiExporter(name, config);
        if (spiExporter == null) {
            throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
        }
        MetricExporterConfiguration.configureIntervalMetricReader(config, meterProvider, spiExporter);
    }

    @Nullable
    static MetricExporter configureSpiExporter(String name, ConfigProperties config) {
        Map<String, MetricExporter> spiExporters = SpiUtil.loadConfigurable(ConfigurableMetricExporterProvider.class, Collections.singletonList(name), ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config);
        return spiExporters.get(name);
    }

    private static void configureLoggingMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        LoggingMetricExporter exporter = new LoggingMetricExporter();
        MetricExporterConfiguration.configureIntervalMetricReader(config, meterProvider, (MetricExporter)exporter);
    }

    @Nullable
    static MetricExporter configureOtlpMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        OtlpHttpMetricExporter exporter;
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter", "OTLP HTTP Metrics Exporter", "opentelemetry-exporter-otlp-http-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTrustedCertificates(arg_0));
            exporter = builder.build();
        } else if (protocol.equals("grpc")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP gRPC Metrics Exporter", "opentelemetry-exporter-otlp-metrics");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTrustedCertificates(arg_0));
            exporter = builder.build();
        } else {
            throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
        }
        MetricExporterConfiguration.configureIntervalMetricReader(config, meterProvider, (MetricExporter)exporter);
        return exporter;
    }

    private static void configureIntervalMetricReader(ConfigProperties config, SdkMeterProvider meterProvider, MetricExporter exporter) {
        IntervalMetricReaderBuilder readerBuilder = IntervalMetricReader.builder().setMetricProducers(Collections.singleton(meterProvider)).setMetricExporter(exporter);
        Duration exportInterval = config.getDuration("otel.imr.export.interval");
        if (exportInterval != null) {
            readerBuilder.setExportIntervalMillis(exportInterval.toMillis());
        }
        IntervalMetricReader reader = readerBuilder.build().startAndRegisterGlobal();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((IntervalMetricReader)reader).shutdown()));
    }

    private static void configurePrometheusMetrics(ConfigProperties config, SdkMeterProvider meterProvider) {
        HTTPServer server;
        String host;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.prometheus.PrometheusCollector", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        PrometheusCollector.builder().setMetricProducer((MetricProducer)meterProvider).buildAndRegister();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port == null) {
            port = 9464;
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) == null) {
            host = "0.0.0.0";
        }
        try {
            server = new HTTPServer(host, port.intValue(), true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create Prometheus server", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HTTPServer)server).stop()));
    }

    private MetricExporterConfiguration() {
    }
}

