/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannelRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.AbstractIoUringServerChannel;
import io.netty.channel.uring.IoUringChannelConfig;
import io.netty.channel.uring.IoUringChannelOption;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.util.Map;

final class IoUringServerSocketChannelConfig
extends IoUringChannelConfig
implements ServerSocketChannelConfig {
    private volatile int backlog = NetUtil.SOMAXCONN;
    private volatile int pendingFastOpenRequestsThreshold;

    IoUringServerSocketChannelConfig(AbstractIoUringServerChannel channel) {
        super(channel, (RecvByteBufAllocator)new ServerChannelRecvByteBufAllocator());
        this.setReuseAddress(true);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{ChannelOption.SO_RCVBUF, ChannelOption.SO_REUSEADDR, ChannelOption.SO_BACKLOG, IoUringChannelOption.SO_REUSEPORT, IoUringChannelOption.IP_FREEBIND, IoUringChannelOption.IP_TRANSPARENT, IoUringChannelOption.TCP_DEFER_ACCEPT, ChannelOption.TCP_FASTOPEN});
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (option == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (option == ChannelOption.SO_BACKLOG) {
            return (T)Integer.valueOf(this.getBacklog());
        }
        if (option == IoUringChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        if (option == IoUringChannelOption.IP_FREEBIND) {
            return (T)Boolean.valueOf(this.isFreeBind());
        }
        if (option == IoUringChannelOption.IP_TRANSPARENT) {
            return (T)Boolean.valueOf(this.isIpTransparent());
        }
        if (option == IoUringChannelOption.TCP_DEFER_ACCEPT) {
            return (T)Integer.valueOf(this.getTcpDeferAccept());
        }
        if (option == ChannelOption.TCP_FASTOPEN) {
            return (T)Integer.valueOf(this.getTcpFastopen());
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        this.validate(option, value);
        if (option == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)value);
        } else if (option == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)value);
        } else if (option == ChannelOption.SO_BACKLOG) {
            this.setBacklog((Integer)value);
        } else if (option == IoUringChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)value);
        } else if (option == IoUringChannelOption.IP_FREEBIND) {
            this.setFreeBind((Boolean)value);
        } else if (option == IoUringChannelOption.IP_TRANSPARENT) {
            this.setIpTransparent((Boolean)value);
        } else if (option == IoUringChannelOption.TCP_DEFER_ACCEPT) {
            this.setTcpDeferAccept((Integer)value);
        } else if (option == ChannelOption.TCP_FASTOPEN) {
            this.setTcpFastopen((Integer)value);
        } else {
            return super.setOption(option, value);
        }
        return true;
    }

    public IoUringServerSocketChannelConfig setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        return this;
    }

    public boolean isReuseAddress() {
        try {
            return ((AbstractIoUringChannel)this.channel).socket.isReuseAddress();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setReuseAddress(boolean reuseAddress) {
        try {
            ((AbstractIoUringChannel)this.channel).socket.setReuseAddress(reuseAddress);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getReceiveBufferSize() {
        try {
            return ((AbstractIoUringChannel)this.channel).socket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setReceiveBufferSize(int receiveBufferSize) {
        try {
            ((AbstractIoUringChannel)this.channel).socket.setReceiveBufferSize(receiveBufferSize);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public IoUringServerSocketChannelConfig setBacklog(int backlog) {
        ObjectUtil.checkPositiveOrZero((int)backlog, (String)"backlog");
        this.backlog = backlog;
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setConnectTimeoutMillis(int connectTimeoutMillis) {
        super.setConnectTimeoutMillis(connectTimeoutMillis);
        return this;
    }

    @Override
    @Deprecated
    public IoUringServerSocketChannelConfig setMaxMessagesPerRead(int maxMessagesPerRead) {
        super.setMaxMessagesPerRead(maxMessagesPerRead);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setWriteSpinCount(int writeSpinCount) {
        super.setWriteSpinCount(writeSpinCount);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setAllocator(ByteBufAllocator allocator) {
        super.setAllocator(allocator);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
        super.setRecvByteBufAllocator(allocator);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setAutoRead(boolean autoRead) {
        super.setAutoRead(autoRead);
        return this;
    }

    @Override
    @Deprecated
    public IoUringServerSocketChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        super.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        return this;
    }

    @Override
    @Deprecated
    public IoUringServerSocketChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        super.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public IoUringServerSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
        super.setMessageSizeEstimator(estimator);
        return this;
    }

    public boolean isReusePort() {
        try {
            return ((IoUringServerSocketChannel)this.channel).socket.isReusePort();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setReusePort(boolean reusePort) {
        try {
            ((IoUringServerSocketChannel)this.channel).socket.setReusePort(reusePort);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isFreeBind() {
        try {
            return ((IoUringServerSocketChannel)this.channel).socket.isIpFreeBind();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setFreeBind(boolean freeBind) {
        try {
            ((IoUringServerSocketChannel)this.channel).socket.setIpFreeBind(freeBind);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public boolean isIpTransparent() {
        try {
            return ((IoUringServerSocketChannel)this.channel).socket.isIpTransparent();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setIpTransparent(boolean transparent) {
        try {
            ((IoUringServerSocketChannel)this.channel).socket.setIpTransparent(transparent);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public IoUringServerSocketChannelConfig setTcpDeferAccept(int deferAccept) {
        try {
            ((IoUringServerSocketChannel)this.channel).socket.setTcpDeferAccept(deferAccept);
            return this;
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpDeferAccept() {
        try {
            return ((IoUringServerSocketChannel)this.channel).socket.getTcpDeferAccept();
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    public int getTcpFastopen() {
        return this.pendingFastOpenRequestsThreshold;
    }

    public IoUringServerSocketChannelConfig setTcpFastopen(int pendingFastOpenRequestsThreshold) {
        this.pendingFastOpenRequestsThreshold = ObjectUtil.checkPositiveOrZero((int)pendingFastOpenRequestsThreshold, (String)"pendingFastOpenRequestsThreshold");
        return this;
    }
}

