/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionEventLoop
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SessionEventLoop.class);
    private final BlockingQueue<FutureTask<String>> sessionQueue;
    private final boolean flushOnExit;

    public SessionEventLoop(BlockingQueue<FutureTask<String>> sessionQueue) {
        this(sessionQueue, true);
    }

    public SessionEventLoop(BlockingQueue<FutureTask<String>> sessionQueue, boolean flushOnExit) {
        this.sessionQueue = sessionQueue;
        this.flushOnExit = flushOnExit;
    }

    @Override
    public void run() {
        while (!Thread.interrupted() || Thread.interrupted() && !this.sessionQueue.isEmpty() && this.flushOnExit) {
            try {
                FutureTask<String> task = this.sessionQueue.take();
                SessionEventLoop.executeTask(task);
            }
            catch (InterruptedException e) {
                LOG.info("SessionEventLoop {} interrupted", (Object)Thread.currentThread().getName());
                Thread.currentThread().interrupt();
            }
        }
        LOG.info("SessionEventLoop {} exit", (Object)Thread.currentThread().getName());
    }

    public static void executeTask(FutureTask<String> task) {
        if (!task.isCancelled()) {
            try {
                task.run();
                task.get();
            }
            catch (Throwable th) {
                LOG.info("SessionEventLoop {} reached exception in processing command", (Object)Thread.currentThread().getName(), (Object)th);
            }
        }
    }
}

