/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.IQueueRepository;
import io.moquette.broker.InMemoryQueue;
import io.moquette.broker.SessionMessageQueue;
import io.moquette.broker.SessionRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MemoryQueueRepository
implements IQueueRepository {
    private Map<String, SessionMessageQueue<SessionRegistry.EnqueuedMessage>> queues = new HashMap<String, SessionMessageQueue<SessionRegistry.EnqueuedMessage>>();

    @Override
    public Set<String> listQueueNames() {
        return Collections.unmodifiableSet(this.queues.keySet());
    }

    @Override
    public boolean containsQueue(String queueName) {
        return this.queues.containsKey(queueName);
    }

    @Override
    public SessionMessageQueue<SessionRegistry.EnqueuedMessage> getOrCreateQueue(String clientId) {
        if (this.containsQueue(clientId)) {
            return this.queues.get(clientId);
        }
        InMemoryQueue queue = new InMemoryQueue(this, clientId);
        this.queues.put(clientId, queue);
        return queue;
    }

    void dropQueue(String queueName) {
        this.queues.remove(queueName);
    }
}

