/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.recording;

import io.mockk.core.ValueClassSupport;
import io.mockk.impl.instantiation.AbstractInstantiator;
import io.mockk.impl.instantiation.AnyValueGenerator;
import io.mockk.impl.recording.SignatureValueGenerator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J;\u0010\u0011\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/mockk/impl/recording/JvmSignatureValueGenerator;", "Lio/mockk/impl/recording/SignatureValueGenerator;", "rnd", "Ljava/util/Random;", "(Ljava/util/Random;)V", "getRnd", "()Ljava/util/Random;", "instantiate", "", "T", "cls", "Lkotlin/reflect/KClass;", "anyValueGeneratorProvider", "Lkotlin/Function0;", "Lio/mockk/impl/instantiation/AnyValueGenerator;", "instantiator", "Lio/mockk/impl/instantiation/AbstractInstantiator;", "signatureValue", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function0;Lio/mockk/impl/instantiation/AbstractInstantiator;)Ljava/lang/Object;", "mockk"})
public final class JvmSignatureValueGenerator
implements SignatureValueGenerator {
    @NotNull
    private final Random rnd;

    public JvmSignatureValueGenerator(@NotNull Random rnd) {
        Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
        this.rnd = rnd;
    }

    @NotNull
    public final Random getRnd() {
        return this.rnd;
    }

    @Override
    @NotNull
    public <T> T signatureValue(@NotNull KClass<T> cls, @NotNull Function0<? extends AnyValueGenerator> anyValueGeneratorProvider2, @NotNull AbstractInstantiator instantiator) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter(anyValueGeneratorProvider2, (String)"anyValueGeneratorProvider");
        Intrinsics.checkNotNullParameter((Object)instantiator, (String)"instantiator");
        if (cls.isValue()) {
            Object[] objectArray;
            KClass valueCls = ValueClassSupport.INSTANCE.getBoxedClass(cls);
            T valueSig = this.signatureValue(valueCls, anyValueGeneratorProvider2, instantiator);
            Object[] objectArray2 = KClasses.getPrimaryConstructor(cls);
            Intrinsics.checkNotNull((Object)objectArray2);
            Object[] $this$signatureValue_u24lambda_u240 = objectArray = objectArray2;
            boolean bl = false;
            KCallablesJvm.setAccessible((KCallable)((KCallable)$this$signatureValue_u24lambda_u240), (boolean)true);
            Object[] constructor = objectArray;
            objectArray = new Object[]{valueSig};
            return (T)constructor.call(objectArray);
        }
        return (T)KClasses.cast(cls, (Object)this.instantiate(cls, anyValueGeneratorProvider2, instantiator));
    }

    private final <T> Object instantiate(KClass<T> cls, Function0<? extends AnyValueGenerator> anyValueGeneratorProvider2, AbstractInstantiator instantiator) {
        Object object;
        KClass<T> kClass = cls;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            object = this.rnd.nextBoolean();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            object = (byte)this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            object = (short)this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.class))) {
            object = Character.valueOf((char)this.rnd.nextInt());
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.class))) {
            object = this.rnd.nextInt();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = this.rnd.nextLong();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(this.rnd.nextFloat());
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = this.rnd.nextDouble();
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            String string = Long.toString(this.rnd.nextLong(), CharsKt.checkRadix((int)16));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        } else if (cls.isSealed()) {
            Object object2;
            block22: {
                for (KClass it : (Iterable)cls.getSealedSubclasses()) {
                    boolean bl = false;
                    Object object3 = this.instantiate(it, anyValueGeneratorProvider2, instantiator);
                    if (object3 == null) continue;
                    object2 = object3;
                    break block22;
                }
                object2 = object = null;
            }
            if (object2 == null) {
                throw new IllegalStateException(("Unable to create proxy for sealed class " + cls + ", available subclasses: " + cls.getSealedSubclasses()).toString());
            }
        } else {
            Object object4 = ((AnyValueGenerator)anyValueGeneratorProvider2.invoke()).anyValue(cls, false, (Function0<? extends Object>)((Function0)new Function0<Object>(instantiator, cls){
                final /* synthetic */ AbstractInstantiator $instantiator;
                final /* synthetic */ KClass<T> $cls;
                {
                    this.$instantiator = $instantiator;
                    this.$cls = $cls;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$instantiator.instantiate(this.$cls);
                }
            }));
            object = object4;
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type T of io.mockk.impl.recording.JvmSignatureValueGenerator.instantiate");
        }
        return object;
    }
}

