/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.reflect.TypeToken;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.ScalarField;
import io.milvus.grpc.SearchResults;
import io.milvus.param.ParamUtils;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.common.IndexBuildState;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConvertUtils {
    public List<QueryResp.QueryResult> getEntities(QueryResults response) {
        ArrayList<QueryResp.QueryResult> entities = new ArrayList<QueryResp.QueryResult>();
        if (response.getFieldsDataList().stream().anyMatch(fieldData -> fieldData.getFieldName().equals("count(*)"))) {
            HashMap<String, Object> countField = new HashMap<String, Object>();
            long numOfEntities = ((ScalarField)response.getFieldsDataList().stream().filter(fieldData -> fieldData.getFieldName().equals("count(*)")).map(FieldData::getScalars).collect(Collectors.toList()).get(0)).getLongData().getData(0);
            countField.put("count(*)", numOfEntities);
            Object queryResult = ((QueryResp.QueryResult.QueryResultBuilder)QueryResp.QueryResult.builder().entity(countField)).build();
            entities.add((QueryResp.QueryResult)queryResult);
            return entities;
        }
        QueryResultsWrapper queryResultsWrapper = new QueryResultsWrapper(response);
        queryResultsWrapper.getRowRecords().forEach(rowRecord -> {
            Object queryResult = ((QueryResp.QueryResult.QueryResultBuilder)QueryResp.QueryResult.builder().entity(rowRecord.getFieldValues())).build();
            entities.add((QueryResp.QueryResult)queryResult);
        });
        return entities;
    }

    public List<List<SearchResp.SearchResult>> getEntities(SearchResults response) {
        SearchResultsWrapper searchResultsWrapper = new SearchResultsWrapper(response.getResults());
        long numQueries = response.getResults().getNumQueries();
        ArrayList<List<SearchResp.SearchResult>> searchResults = new ArrayList<List<SearchResp.SearchResult>>();
        int i = 0;
        while ((long)i < numQueries) {
            searchResults.add(searchResultsWrapper.getIDScore(i).stream().map(idScore -> ((SearchResp.SearchResult.SearchResultBuilder)((SearchResp.SearchResult.SearchResultBuilder)((SearchResp.SearchResult.SearchResultBuilder)SearchResp.SearchResult.builder().entity(idScore.getFieldValues())).score(Float.valueOf(idScore.getScore()))).id(idScore.getStrID().isEmpty() ? Long.valueOf(idScore.getLongID()) : idScore.getStrID())).build()).collect(Collectors.toList()));
            ++i;
        }
        return searchResults;
    }

    public DescribeIndexResp convertToDescribeIndexResp(List<IndexDescription> response) {
        ArrayList<DescribeIndexResp.IndexDesc> descs = new ArrayList<DescribeIndexResp.IndexDesc>();
        for (IndexDescription description : response) {
            Map<String, String> extraParams = new HashMap<String, String>();
            List<KeyValuePair> params = description.getParamsList();
            IndexParam.IndexType indexType = IndexParam.IndexType.None;
            IndexParam.MetricType metricType = IndexParam.MetricType.INVALID;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (KeyValuePair param : params) {
                if (param.getKey().equals("index_type")) {
                    indexType = IndexParam.IndexType.valueOf(param.getValue().toUpperCase());
                    continue;
                }
                if (param.getKey().equals("metric_type")) {
                    metricType = IndexParam.MetricType.valueOf(param.getValue());
                    continue;
                }
                if (param.getKey().equals("mmap.enabled")) {
                    properties.put(param.getKey(), param.getValue());
                    continue;
                }
                if (!param.getKey().equals("params")) continue;
                extraParams = (Map)JsonUtils.fromJson(param.getValue(), new TypeToken<Map<String, String>>(){}.getType());
            }
            Object desc = ((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)((DescribeIndexResp.IndexDesc.IndexDescBuilder)DescribeIndexResp.IndexDesc.builder().indexName(description.getIndexName())).fieldName(description.getFieldName())).id(description.getIndexID())).indexType(indexType)).metricType(metricType)).totalRows(description.getTotalRows())).indexedRows(description.getIndexedRows())).pendingIndexRows(description.getPendingIndexRows())).indexState(IndexBuildState.valueOf(description.getState().name()))).indexFailedReason(description.getIndexStateFailReason())).extraParams(extraParams)).properties(properties)).build();
            descs.add((DescribeIndexResp.IndexDesc)desc);
        }
        return ((DescribeIndexResp.DescribeIndexRespBuilder)DescribeIndexResp.builder().indexDescriptions(descs)).build();
    }

    public DescribeCollectionResp convertDescCollectionResp(DescribeCollectionResponse response) {
        HashMap<String, String> properties = new HashMap<String, String>();
        response.getPropertiesList().forEach(prop -> properties.put(prop.getKey(), prop.getValue()));
        Object describeCollectionResp = ((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)((DescribeCollectionResp.DescribeCollectionRespBuilder)DescribeCollectionResp.builder().collectionName(response.getCollectionName())).databaseName(response.getDbName())).description(response.getSchema().getDescription())).numOfPartitions(response.getNumPartitions())).collectionSchema(SchemaUtils.convertFromGrpcCollectionSchema(response.getSchema()))).autoID(response.getSchema().getFieldsList().stream().anyMatch(FieldSchema::getAutoID))).enableDynamicField(response.getSchema().getEnableDynamicField())).fieldNames(response.getSchema().getFieldsList().stream().map(FieldSchema::getName).collect(Collectors.toList()))).vectorFieldNames(response.getSchema().getFieldsList().stream().filter(fieldSchema -> ParamUtils.isVectorDataType(fieldSchema.getDataType())).map(FieldSchema::getName).collect(Collectors.toList()))).primaryFieldName((String)response.getSchema().getFieldsList().stream().filter(FieldSchema::getIsPrimaryKey).map(FieldSchema::getName).collect(Collectors.toList()).get(0))).createTime(response.getCreatedTimestamp())).consistencyLevel(ConsistencyLevel.valueOf(response.getConsistencyLevel().name().toUpperCase()))).properties(properties)).build();
        return describeCollectionResp;
    }
}

