/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.index;

import io.milvus.grpc.AlterIndexRequest;
import io.milvus.grpc.CreateIndexRequest;
import io.milvus.grpc.DescribeIndexRequest;
import io.milvus.grpc.DescribeIndexResponse;
import io.milvus.grpc.DropIndexRequest;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.IndexDescription;
import io.milvus.grpc.KeyValuePair;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.param.ParamUtils;
import io.milvus.v2.common.IndexParam;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.index.request.AlterIndexReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexService
extends BaseService {
    public Void createIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateIndexReq request) {
        for (IndexParam indexParam : request.getIndexParams()) {
            String title = String.format("CreateIndexRequest collectionName:%s, fieldName:%s", request.getCollectionName(), indexParam.getFieldName());
            CreateIndexRequest createIndexRequest = CreateIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setIndexName(indexParam.getIndexName()).setFieldName(indexParam.getFieldName()).addExtraParams(KeyValuePair.newBuilder().setKey("index_type").setValue(indexParam.getIndexType().getName()).build()).build();
            if (indexParam.getMetricType() != null) {
                createIndexRequest = createIndexRequest.toBuilder().addExtraParams(KeyValuePair.newBuilder().setKey("metric_type").setValue(indexParam.getMetricType().name()).build()).build();
            }
            if (indexParam.getExtraParams() != null) {
                for (String key : indexParam.getExtraParams().keySet()) {
                    createIndexRequest = createIndexRequest.toBuilder().addExtraParams(KeyValuePair.newBuilder().setKey(key).setValue(String.valueOf(indexParam.getExtraParams().get(key))).build()).build();
                }
            }
            Status status = blockingStub.createIndex(createIndexRequest);
            this.rpcUtils.handleResponse(title, status);
        }
        return null;
    }

    public Void dropIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropIndexReq request) {
        String title = String.format("DropIndexRequest collectionName:%s, fieldName:%s, indexName:%s", request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DropIndexRequest dropIndexRequest = DropIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName()).build();
        Status status = blockingStub.dropIndex(dropIndexRequest);
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterIndexReq request) {
        String title = String.format("AlterIndexRequest collectionName:%s, indexName:%s", request.getCollectionName(), request.getIndexName());
        AlterIndexRequest.Builder builder = AlterIndexRequest.newBuilder();
        List<KeyValuePair> propertiesList = ParamUtils.AssembleKvPair(request.getProperties());
        if (CollectionUtils.isNotEmpty(propertiesList)) {
            propertiesList.forEach(builder::addExtraParams);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDatabaseName())) {
            builder.setDbName(request.getDatabaseName());
        }
        AlterIndexRequest alterIndexRequest = builder.setCollectionName(request.getCollectionName()).setIndexName(request.getIndexName()).build();
        Status response = blockingStub.alterIndex(alterIndexRequest);
        this.rpcUtils.handleResponse(title, response);
        return null;
    }

    public DescribeIndexResp describeIndex(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeIndexReq request) {
        String title = String.format("DescribeIndexRequest collectionName:%s, fieldName:%s, indexName:%s", request.getCollectionName(), request.getFieldName(), request.getIndexName());
        DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName() == null ? "" : request.getFieldName()).setIndexName(request.getIndexName() == null ? "" : request.getIndexName()).build();
        DescribeIndexResponse response = blockingStub.describeIndex(describeIndexRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        List<IndexDescription> indexs = response.getIndexDescriptionsList().stream().filter(index -> index.getIndexName().equals(request.getIndexName()) || index.getFieldName().equals(request.getFieldName())).collect(Collectors.toList());
        if (indexs.isEmpty()) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "Index not found");
        }
        if (indexs.size() > 1) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "More than one index found");
        }
        return this.convertUtils.convertToDescribeIndexResp(indexs);
    }

    public List<String> listIndexes(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListIndexesReq request) {
        DescribeIndexResponse response;
        String title = String.format("ListIndexesRequest collectionName:%s", request.getCollectionName());
        DescribeIndexRequest describeIndexRequest = DescribeIndexRequest.newBuilder().setCollectionName(request.getCollectionName()).build();
        if (request.getFieldName() != null) {
            describeIndexRequest = describeIndexRequest.toBuilder().setFieldName(request.getFieldName()).build();
        }
        if ((response = blockingStub.describeIndex(describeIndexRequest)).getStatus().getErrorCode() == ErrorCode.IndexNotExist || response.getStatus().getCode() == 700) {
            return new ArrayList<String>();
        }
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<String> indexNames = new ArrayList<String>();
        response.getIndexDescriptionsList().forEach(index -> indexNames.add(index.getIndexName()));
        return indexNames;
    }
}

