/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.service.collection.CollectionService;
import io.milvus.v2.service.collection.request.AlterCollectionReq;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.request.DescribeCollectionReq;
import io.milvus.v2.service.collection.request.DropCollectionReq;
import io.milvus.v2.service.collection.request.GetCollectionStatsReq;
import io.milvus.v2.service.collection.request.GetLoadStateReq;
import io.milvus.v2.service.collection.request.HasCollectionReq;
import io.milvus.v2.service.collection.request.LoadCollectionReq;
import io.milvus.v2.service.collection.request.ReleaseCollectionReq;
import io.milvus.v2.service.collection.request.RenameCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.collection.response.GetCollectionStatsResp;
import io.milvus.v2.service.collection.response.ListCollectionsResp;
import io.milvus.v2.service.index.IndexService;
import io.milvus.v2.service.index.request.AlterIndexReq;
import io.milvus.v2.service.index.request.CreateIndexReq;
import io.milvus.v2.service.index.request.DescribeIndexReq;
import io.milvus.v2.service.index.request.DropIndexReq;
import io.milvus.v2.service.index.request.ListIndexesReq;
import io.milvus.v2.service.index.response.DescribeIndexResp;
import io.milvus.v2.service.partition.PartitionService;
import io.milvus.v2.service.partition.request.CreatePartitionReq;
import io.milvus.v2.service.partition.request.DropPartitionReq;
import io.milvus.v2.service.partition.request.HasPartitionReq;
import io.milvus.v2.service.partition.request.ListPartitionsReq;
import io.milvus.v2.service.partition.request.LoadPartitionsReq;
import io.milvus.v2.service.partition.request.ReleasePartitionsReq;
import io.milvus.v2.service.rbac.RoleService;
import io.milvus.v2.service.rbac.UserService;
import io.milvus.v2.service.rbac.request.CreateRoleReq;
import io.milvus.v2.service.rbac.request.CreateUserReq;
import io.milvus.v2.service.rbac.request.DescribeRoleReq;
import io.milvus.v2.service.rbac.request.DescribeUserReq;
import io.milvus.v2.service.rbac.request.DropRoleReq;
import io.milvus.v2.service.rbac.request.DropUserReq;
import io.milvus.v2.service.rbac.request.GrantPrivilegeReq;
import io.milvus.v2.service.rbac.request.GrantRoleReq;
import io.milvus.v2.service.rbac.request.RevokePrivilegeReq;
import io.milvus.v2.service.rbac.request.RevokeRoleReq;
import io.milvus.v2.service.rbac.request.UpdatePasswordReq;
import io.milvus.v2.service.rbac.response.DescribeRoleResp;
import io.milvus.v2.service.rbac.response.DescribeUserResp;
import io.milvus.v2.service.utility.UtilityService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import io.milvus.v2.service.vector.VectorService;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.ClientUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusClientV2 {
    private static final Logger logger = LoggerFactory.getLogger(MilvusClientV2.class);
    private ManagedChannel channel;
    private MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final ClientUtils clientUtils = new ClientUtils();
    private final CollectionService collectionService = new CollectionService();
    private final IndexService indexService = new IndexService();
    private final VectorService vectorService = new VectorService();
    private final PartitionService partitionService = new PartitionService();
    private final UserService userService = new UserService();
    private final RoleService roleService = new RoleService();
    private final UtilityService utilityService = new UtilityService();
    private ConnectConfig connectConfig;

    public MilvusClientV2(ConnectConfig connectConfig) {
        if (connectConfig != null) {
            this.connect(connectConfig);
        }
    }

    private void connect(ConnectConfig connectConfig) {
        this.connectConfig = connectConfig;
        try {
            if (this.channel != null) {
                this.close(3L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.channel = this.clientUtils.getChannel(connectConfig);
        this.blockingStub = connectConfig.getRpcDeadlineMs() > 0L ? (MilvusServiceGrpc.MilvusServiceBlockingStub)((MilvusServiceGrpc.MilvusServiceBlockingStub)MilvusServiceGrpc.newBlockingStub((Channel)this.channel).withWaitForReady()).withDeadlineAfter(connectConfig.getRpcDeadlineMs(), TimeUnit.MILLISECONDS) : MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        if (connectConfig.getDbName() != null) {
            this.clientUtils.checkDatabaseExist(this.blockingStub, connectConfig.getDbName());
        }
    }

    public void useDatabase(@NonNull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.clientUtils.checkDatabaseExist(this.blockingStub, dbName);
        try {
            this.connectConfig.setDbName(dbName);
            this.close(3L);
            this.connect(this.connectConfig);
        }
        catch (InterruptedException e) {
            logger.error("close connect error");
        }
    }

    public void createCollection(CreateCollectionReq request) {
        this.collectionService.createCollection(this.blockingStub, request);
    }

    public CreateCollectionReq.CollectionSchema createSchema() {
        return this.collectionService.createSchema();
    }

    public ListCollectionsResp listCollections() {
        return this.collectionService.listCollections(this.blockingStub);
    }

    public void dropCollection(DropCollectionReq request) {
        this.collectionService.dropCollection(this.blockingStub, request);
    }

    public void alterCollection(AlterCollectionReq request) {
        this.collectionService.alterCollection(this.blockingStub, request);
    }

    public Boolean hasCollection(HasCollectionReq request) {
        return this.collectionService.hasCollection(this.blockingStub, request);
    }

    public DescribeCollectionResp describeCollection(DescribeCollectionReq request) {
        return this.collectionService.describeCollection(this.blockingStub, request);
    }

    public GetCollectionStatsResp getCollectionStats(GetCollectionStatsReq request) {
        return this.collectionService.getCollectionStats(this.blockingStub, request);
    }

    public void renameCollection(RenameCollectionReq request) {
        this.collectionService.renameCollection(this.blockingStub, request);
    }

    public void loadCollection(LoadCollectionReq request) {
        this.collectionService.loadCollection(this.blockingStub, request);
    }

    public void releaseCollection(ReleaseCollectionReq request) {
        this.collectionService.releaseCollection(this.blockingStub, request);
    }

    public Boolean getLoadState(GetLoadStateReq request) {
        return this.collectionService.getLoadState(this.blockingStub, request);
    }

    public void createIndex(CreateIndexReq request) {
        this.indexService.createIndex(this.blockingStub, request);
    }

    public void dropIndex(DropIndexReq request) {
        this.indexService.dropIndex(this.blockingStub, request);
    }

    public void alterIndex(AlterIndexReq request) {
        this.indexService.alterIndex(this.blockingStub, request);
    }

    public DescribeIndexResp describeIndex(DescribeIndexReq request) {
        return this.indexService.describeIndex(this.blockingStub, request);
    }

    public List<String> listIndexes(ListIndexesReq request) {
        return this.indexService.listIndexes(this.blockingStub, request);
    }

    public InsertResp insert(InsertReq request) {
        return this.vectorService.insert(this.blockingStub, request);
    }

    public UpsertResp upsert(UpsertReq request) {
        return this.vectorService.upsert(this.blockingStub, request);
    }

    public DeleteResp delete(DeleteReq request) {
        return this.vectorService.delete(this.blockingStub, request);
    }

    public GetResp get(GetReq request) {
        return this.vectorService.get(this.blockingStub, request);
    }

    public QueryResp query(QueryReq request) {
        return this.vectorService.query(this.blockingStub, request);
    }

    public SearchResp search(SearchReq request) {
        return this.vectorService.search(this.blockingStub, request);
    }

    public SearchResp hybridSearch(HybridSearchReq request) {
        return this.vectorService.hybridSearch(this.blockingStub, request);
    }

    public QueryIterator queryIterator(QueryIteratorReq request) {
        return this.vectorService.queryIterator(this.blockingStub, request);
    }

    public SearchIterator searchIterator(SearchIteratorReq request) {
        return this.vectorService.searchIterator(this.blockingStub, request);
    }

    public void createPartition(CreatePartitionReq request) {
        this.partitionService.createPartition(this.blockingStub, request);
    }

    public void dropPartition(DropPartitionReq request) {
        this.partitionService.dropPartition(this.blockingStub, request);
    }

    public Boolean hasPartition(HasPartitionReq request) {
        return this.partitionService.hasPartition(this.blockingStub, request);
    }

    public List<String> listPartitions(ListPartitionsReq request) {
        return this.partitionService.listPartitions(this.blockingStub, request);
    }

    public void loadPartitions(LoadPartitionsReq request) {
        this.partitionService.loadPartitions(this.blockingStub, request);
    }

    public void releasePartitions(ReleasePartitionsReq request) {
        this.partitionService.releasePartitions(this.blockingStub, request);
    }

    public List<String> listUsers() {
        return this.userService.listUsers(this.blockingStub);
    }

    public DescribeUserResp describeUser(DescribeUserReq request) {
        return this.userService.describeUser(this.blockingStub, request);
    }

    public void createUser(CreateUserReq request) {
        this.userService.createUser(this.blockingStub, request);
    }

    public void updatePassword(UpdatePasswordReq request) {
        this.userService.updatePassword(this.blockingStub, request);
    }

    public void dropUser(DropUserReq request) {
        this.userService.dropUser(this.blockingStub, request);
    }

    public List<String> listRoles() {
        return this.roleService.listRoles(this.blockingStub);
    }

    public DescribeRoleResp describeRole(DescribeRoleReq request) {
        return this.roleService.describeRole(this.blockingStub, request);
    }

    public void createRole(CreateRoleReq request) {
        this.roleService.createRole(this.blockingStub, request);
    }

    public void dropRole(DropRoleReq request) {
        this.roleService.dropRole(this.blockingStub, request);
    }

    public void grantPrivilege(GrantPrivilegeReq request) {
        this.roleService.grantPrivilege(this.blockingStub, request);
    }

    public void revokePrivilege(RevokePrivilegeReq request) {
        this.roleService.revokePrivilege(this.blockingStub, request);
    }

    public void grantRole(GrantRoleReq request) {
        this.roleService.grantRole(this.blockingStub, request);
    }

    public void revokeRole(RevokeRoleReq request) {
        this.roleService.revokeRole(this.blockingStub, request);
    }

    public void createAlias(CreateAliasReq request) {
        this.utilityService.createAlias(this.blockingStub, request);
    }

    public void dropAlias(DropAliasReq request) {
        this.utilityService.dropAlias(this.blockingStub, request);
    }

    public void alterAlias(AlterAliasReq request) {
        this.utilityService.alterAlias(this.blockingStub, request);
    }

    public ListAliasResp listAliases(ListAliasesReq request) {
        return this.utilityService.listAliases(this.blockingStub, request);
    }

    public DescribeAliasResp describeAlias(DescribeAliasReq request) {
        return this.utilityService.describeAlias(this.blockingStub, request);
    }

    public void close(long maxWaitSeconds) throws InterruptedException {
        if (this.channel != null) {
            this.channel.shutdownNow();
            this.channel.awaitTermination(maxWaitSeconds, TimeUnit.SECONDS);
        }
    }

    public void setBlockingStub(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        this.blockingStub = blockingStub;
    }
}

