/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DescribeDatabaseParam {
    private final String databaseName;

    private DescribeDatabaseParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "DescribeDatabaseParam(databaseName=" + this.getDatabaseName() + ")";
    }

    public static final class Builder {
        private String databaseName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public DescribeDatabaseParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.databaseName, "Database name");
            return new DescribeDatabaseParam(this);
        }
    }
}

