/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.partition;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GetPartitionStatisticsParam {
    private final String databaseName;
    private final String collectionName;
    private final String partitionName;
    private final boolean flushCollection;

    private GetPartitionStatisticsParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.flushCollection = builder.flushCollection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean isFlushCollection() {
        return this.flushCollection;
    }

    public String toString() {
        return "GetPartitionStatisticsParam(databaseName=" + this.getDatabaseName() + ", collectionName=" + this.getCollectionName() + ", partitionName=" + this.getPartitionName() + ", flushCollection=" + this.isFlushCollection() + ")";
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private String partitionName;
        private Boolean flushCollection = Boolean.FALSE;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withFlush(@NonNull Boolean flush) {
            if (flush == null) {
                throw new NullPointerException("flush is marked non-null but is null");
            }
            this.flushCollection = flush;
            return this;
        }

        public GetPartitionStatisticsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.partitionName, "Partition name");
            return new GetPartitionStatisticsParam(this);
        }
    }
}

