/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.sourcegen.bytecode.AbstractSwitchWriter;
import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

final class SwitchStatementWriter
extends AbstractSwitchWriter
implements StatementWriter {
    private final StatementDef.Switch aSwitch;

    public SwitchStatementWriter(StatementDef.Switch aSwitch) {
        this.aSwitch = aSwitch;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        ClassTypeDef classTypeDef;
        boolean isStringSwitch;
        TypeDef typeDef = this.aSwitch.expression().type();
        boolean bl = isStringSwitch = typeDef instanceof ClassTypeDef && (classTypeDef = (ClassTypeDef)typeDef).getName().equals(String.class.getName());
        if (isStringSwitch) {
            this.writeStringSwitch(generatorAdapter, context, finallyBlock, this.aSwitch);
        } else {
            this.writeSwitch(generatorAdapter, context, finallyBlock, this.aSwitch);
        }
    }

    private void writeSwitch(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock, StatementDef.Switch aSwitch) {
        SwitchStatementWriter.pushSwitchExpression(generatorAdapter, context, aSwitch.expression());
        Map<Integer, StatementDef> map = aSwitch.cases().entrySet().stream().map(e -> Map.entry(SwitchStatementWriter.toSwitchKey((ExpressionDef.Constant)e.getKey()), (StatementDef)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.tableSwitch(generatorAdapter, context, map, aSwitch.defaultCase(), finallyBlock);
    }

    private void writeStringSwitch(final GeneratorAdapter generatorAdapter, final MethodContext context, final Runnable finallyBlock, StatementDef.Switch aSwitch) {
        ExpressionDef expression = aSwitch.expression();
        ExpressionWriter.writeExpression(generatorAdapter, context, expression);
        final Type stringType = Type.getType(String.class);
        final int switchValueLocal = generatorAdapter.newLocal(stringType);
        generatorAdapter.storeLocal(switchValueLocal, stringType);
        generatorAdapter.loadLocal(switchValueLocal, stringType);
        generatorAdapter.invokeVirtual(stringType, Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(String.class, (String)"hashCode", (Class[])new Class[0])));
        final Map<Integer, Map.Entry> map = aSwitch.cases().entrySet().stream().map(e -> Map.entry(SwitchStatementWriter.toSwitchKey((ExpressionDef.Constant)e.getKey()), Map.entry((ExpressionDef.Constant)e.getKey(), (StatementDef)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        int[] keys = map.keySet().stream().mapToInt(x -> x).sorted().toArray();
        final Label defaultEnd = new Label();
        final Label finalEnd = new Label();
        generatorAdapter.tableSwitch(keys, new TableSwitchGenerator(){

            public void generateCase(int key, Label end) {
                Map.Entry e = (Map.Entry)map.get(key);
                ExpressionDef.Constant constant = (ExpressionDef.Constant)e.getKey();
                Object object = constant.value();
                if (!(object instanceof String)) {
                    throw new IllegalStateException("Expected a string value got: " + String.valueOf(constant));
                }
                String stringValue = (String)object;
                generatorAdapter.loadLocal(switchValueLocal, stringType);
                generatorAdapter.push(stringValue);
                generatorAdapter.invokeVirtual(stringType, Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(String.class, (String)"equals", (Class[])new Class[]{Object.class})));
                generatorAdapter.push(true);
                generatorAdapter.ifCmp(Type.BOOLEAN_TYPE, 154, defaultEnd);
                StatementWriter.of((StatementDef)e.getValue()).writeScoped(generatorAdapter, context, finallyBlock);
                generatorAdapter.goTo(finalEnd);
            }

            public void generateDefault() {
                generatorAdapter.goTo(defaultEnd);
            }
        });
        generatorAdapter.visitLabel(defaultEnd);
        if (aSwitch.defaultCase() != null) {
            StatementWriter.of(aSwitch.defaultCase()).writeScoped(generatorAdapter, context, finallyBlock);
        }
        generatorAdapter.visitLabel(finalEnd);
    }

    private void tableSwitch(GeneratorAdapter generatorAdapter, MethodContext context, Map<Integer, StatementDef> cases, @Nullable StatementDef defaultCase, @Nullable Runnable finallyBlock) {
        int[] keys = cases.keySet().stream().sorted().mapToInt(i -> i).toArray();
        float density = keys.length == 0 ? 0.0f : (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1);
        this.tableSwitch(generatorAdapter, context, keys, cases, defaultCase, finallyBlock, density >= 0.5f);
    }

    private void tableSwitch(GeneratorAdapter generatorAdapter, MethodContext context, int[] keys, Map<Integer, StatementDef> cases, @Nullable StatementDef defaultCase, @Nullable Runnable finallyBlock, boolean useTable) {
        Label defaultLabel = generatorAdapter.newLabel();
        Label endLabel = generatorAdapter.newLabel();
        if (keys.length > 0) {
            int numKeys = keys.length;
            if (useTable) {
                int min = keys[0];
                int max = keys[numKeys - 1];
                int range = max - min + 1;
                Object[] objectArray = new Label[range];
                Arrays.fill(objectArray, defaultLabel);
                ArrayList<Map.Entry<Label, StatementDef>> result = new ArrayList<Map.Entry<Label, StatementDef>>();
                for (int key : keys) {
                    int i = key - min;
                    StatementDef statementDef = cases.get(key);
                    Label existingLabel = SwitchStatementWriter.findIndex(result, statementDef);
                    if (existingLabel == null) {
                        Label newLabel = generatorAdapter.newLabel();
                        objectArray[i] = newLabel;
                        result.add(Map.entry(newLabel, statementDef));
                        continue;
                    }
                    objectArray[i] = existingLabel;
                }
                generatorAdapter.visitTableSwitchInsn(min, max, defaultLabel, (Label[])objectArray);
                Object object = result.iterator();
                while (object.hasNext()) {
                    Map.Entry e = (Map.Entry)object.next();
                    generatorAdapter.mark((Label)e.getKey());
                    StatementWriter.of((StatementDef)e.getValue()).writeScoped(generatorAdapter, context, finallyBlock);
                    generatorAdapter.goTo(endLabel);
                }
            } else {
                Label[] labels = new Label[keys.length];
                ArrayList<Map.Entry<Label, StatementDef>> result = new ArrayList<Map.Entry<Label, StatementDef>>();
                for (int i = 0; i < numKeys; ++i) {
                    int n = keys[i];
                    StatementDef statementDef = cases.get(n);
                    Label existingLabel = SwitchStatementWriter.findIndex(result, statementDef);
                    if (existingLabel == null) {
                        Label newLabel;
                        labels[i] = newLabel = generatorAdapter.newLabel();
                        result.add(Map.entry(newLabel, statementDef));
                        continue;
                    }
                    labels[i] = existingLabel;
                }
                generatorAdapter.visitLookupSwitchInsn(defaultLabel, keys, labels);
                for (Map.Entry entry : result) {
                    generatorAdapter.mark((Label)entry.getKey());
                    StatementWriter.of((StatementDef)entry.getValue()).writeScoped(generatorAdapter, context, finallyBlock);
                    generatorAdapter.goTo(endLabel);
                }
            }
        }
        generatorAdapter.mark(defaultLabel);
        if (defaultCase != null) {
            StatementWriter.of(defaultCase).writeScoped(generatorAdapter, context, finallyBlock);
        }
        generatorAdapter.mark(endLabel);
    }

    private static Label findIndex(List<Map.Entry<Label, StatementDef>> result, StatementDef statement) {
        for (Map.Entry<Label, StatementDef> e : result) {
            if (e.getValue() != statement) continue;
            return e.getKey();
        }
        return null;
    }
}

