/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class ReturnStatementWriter
implements StatementWriter {
    private final StatementDef.Return aReturn;

    public ReturnStatementWriter(StatementDef.Return aReturn) {
        this.aReturn = aReturn;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        this.aReturn.validate(context.methodDef());
        if (this.aReturn.expression() != null) {
            ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, this.aReturn.expression(), context.methodDef().getReturnType());
            this.pushFinallyStatement(generatorAdapter, context, finallyBlock, context.methodDef().getReturnType());
        } else if (finallyBlock != null) {
            finallyBlock.run();
        }
        generatorAdapter.returnValue();
    }

    private void pushFinallyStatement(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock, TypeDef expTypeDef) {
        if (finallyBlock != null) {
            if (expTypeDef.equals(TypeDef.VOID)) {
                finallyBlock.run();
            } else {
                Type expType = TypeUtils.getType(expTypeDef, context.objectDef());
                int returnLocal = generatorAdapter.newLocal(expType);
                generatorAdapter.storeLocal(returnLocal);
                finallyBlock.run();
                generatorAdapter.loadLocal(returnLocal);
            }
        }
    }
}

