/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode.statement;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.TypeUtils;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.bytecode.statement.StatementWriter;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.VariableDef;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

final class DefineAndAssignStatementWriter
implements StatementWriter {
    private final StatementDef.DefineAndAssign assign;

    public DefineAndAssignStatementWriter(StatementDef.DefineAndAssign assign) {
        this.assign = assign;
    }

    @Override
    public void write(GeneratorAdapter generatorAdapter, MethodContext context, Runnable finallyBlock) {
        VariableDef.Local local = this.assign.variable();
        Type localType = TypeUtils.getType(local.type(), context.objectDef());
        Label startVariable = new Label();
        generatorAdapter.visitLabel(startVariable);
        int localIndex = generatorAdapter.newLocal(localType);
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, this.assign.expression(), local.type());
        generatorAdapter.storeLocal(localIndex, localType);
        MethodContext.LocalData prevLocal = context.locals().put(local.name(), new MethodContext.LocalData(local.name(), localType, startVariable, localIndex));
        if (prevLocal != null) {
            throw new IllegalStateException("Duplicate local name: " + local.name());
        }
    }
}

