/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.EnumDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@Internal
public class EnumGenUtils {
    private static final Method CLONE_METHOD = ReflectionUtils.getRequiredMethod(Object.class, (String)"clone", (Class[])new Class[0]);
    private static final Method ENUM_VALUE_OF_METHOD = ReflectionUtils.getRequiredMethod(Enum.class, (String)"valueOf", (Class[])new Class[]{Class.class, String.class});
    private static final Constructor<?> ENUM_CONSTRUCTOR = ReflectionUtils.getRequiredInternalConstructor(Enum.class, (Class[])new Class[]{String.class, Integer.TYPE});

    public static ClassDef toClassDef(EnumDef enumDef) {
        ClassTypeDef enumTypeDef = ClassTypeDef.of((String)enumDef.getName());
        ClassTypeDef baseEnumTypeDef = ClassTypeDef.of(Enum.class);
        ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)enumDef.getName()).addFields((Collection)enumDef.getFields()).addModifiers((Collection)enumDef.getModifiers())).addModifiers(new Modifier[]{Modifier.FINAL})).superclass(TypeDef.parameterized((ClassTypeDef)baseEnumTypeDef, (TypeDef[])new TypeDef[]{enumTypeDef})).addSuperinterfaces((Collection)enumDef.getSuperinterfaces())).addInnerType((Collection)enumDef.getInnerTypes());
        if (enumDef.isSynthetic()) {
            classDefBuilder.synthetic();
        }
        int i = 0;
        for (Map.Entry e : enumDef.getEnumConstants().entrySet()) {
            ArrayList values = new ArrayList();
            values.add(ExpressionDef.constant(e.getKey()));
            values.add(TypeDef.Primitive.INT.constant((Object)i++));
            values.addAll((Collection)e.getValue());
            FieldDef enumField = ((FieldDef.FieldDefBuilder)FieldDef.builder((String)((String)e.getKey()), (TypeDef)enumTypeDef).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.STATIC, Modifier.PUBLIC})).initializer((ExpressionDef)enumTypeDef.instantiate((List)values)).build();
            classDefBuilder.addField(enumField);
        }
        int constructorIndex = 0;
        boolean constructorAdded = false;
        for (MethodDef method : enumDef.getMethods()) {
            if (!method.isConstructor()) continue;
            EnumGenUtils.addEnumConstructor(classDefBuilder, method, constructorIndex);
            constructorAdded = true;
        }
        if (!constructorAdded) {
            classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.override(ENUM_CONSTRUCTOR).overrideModifiers(new Modifier[]{Modifier.PRIVATE})).build((aThis, methodParameters) -> aThis.superRef().invokeConstructor(ENUM_CONSTRUCTOR, new ExpressionDef[]{(ExpressionDef)methodParameters.get(0), (ExpressionDef)methodParameters.get(1)})));
        }
        MethodDef internalValuesMethod = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)"$values").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE})).build((aThis, methodParameters) -> enumTypeDef.array().instantiate(enumDef.getEnumConstants().keySet().stream().map(name -> enumTypeDef.getStaticField(name, (TypeDef)enumTypeDef)).toList()).returning());
        classDefBuilder.addMethod(internalValuesMethod);
        FieldDef valuesField = ((FieldDef.FieldDefBuilder)FieldDef.builder((String)"$VALUES").ofType((TypeDef)enumTypeDef.array()).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE})).initializer((ExpressionDef)enumTypeDef.invokeStatic(internalValuesMethod, new ExpressionDef[0])).build();
        classDefBuilder.addField(valuesField);
        classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)"values").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC})).returns((TypeDef)enumTypeDef.array()).build((aThis2, methodParameters2) -> enumTypeDef.getStaticField(valuesField).invoke(CLONE_METHOD, new ExpressionDef[0]).cast((TypeDef)enumTypeDef.array()).returning()));
        classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.builder((String)"valueOf").addParameter(ParameterDef.of((String)"value", (TypeDef)TypeDef.STRING)).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC})).build((aThis, methodParameters) -> baseEnumTypeDef.invokeStatic(ENUM_VALUE_OF_METHOD, new ExpressionDef[]{ExpressionDef.constant((Object)enumTypeDef), (ExpressionDef)methodParameters.get(0)}).cast((TypeDef)enumTypeDef).returning()));
        enumDef.getMethods().stream().filter(m -> !m.isConstructor()).forEach(arg_0 -> ((ClassDef.ClassDefBuilder)classDefBuilder).addMethod(arg_0));
        return classDefBuilder.build();
    }

    private static void addEnumConstructor(ClassDef.ClassDefBuilder classDefBuilder, MethodDef method, int constructorIndex) {
        MethodDef constructorMethod = ((MethodDef.MethodDefBuilder)MethodDef.builder((String)("$constructor" + constructorIndex)).addModifiers(new Modifier[]{Modifier.PRIVATE})).addParameters((Collection)method.getParameters()).returns((TypeDef)TypeDef.VOID).addStatements((Collection)method.getStatements()).build();
        classDefBuilder.addMethod(constructorMethod);
        classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)MethodDef.constructor().addModifiers(new Modifier[]{Modifier.PRIVATE})).addParameters((Class[])ENUM_CONSTRUCTOR.getParameterTypes()).addParameters((Collection)method.getParameters()).build((aThis, methodParameters) -> StatementDef.multi((StatementDef[])new StatementDef[]{aThis.superRef().invokeConstructor(ENUM_CONSTRUCTOR, new ExpressionDef[]{(ExpressionDef)methodParameters.get(0), (ExpressionDef)methodParameters.get(1)}), aThis.invoke(constructorMethod, methodParameters.subList(2, methodParameters.size()))})));
    }

    public static boolean isEnumField(ObjectDef objectDef, FieldDef fieldDef) {
        ExpressionDef.NewInstance ni;
        Object t;
        ClassDef classDef;
        Optional initializer = fieldDef.getInitializer();
        return objectDef instanceof ClassDef && EnumGenUtils.isEnum(classDef = (ClassDef)objectDef) && initializer.isPresent() && (t = initializer.get()) instanceof ExpressionDef.NewInstance && (ni = (ExpressionDef.NewInstance)t).type().getName().equals(classDef.getName());
    }

    public static boolean isEnum(ClassDef classDef) {
        return classDef.getSuperclass() != null && classDef.getSuperclass().getName().equals(Enum.class.getName());
    }
}

