/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.sourcegen.bytecode;

import io.micronaut.sourcegen.bytecode.MethodContext;
import io.micronaut.sourcegen.bytecode.expression.ExpressionWriter;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.TypeDef;
import org.objectweb.asm.commons.GeneratorAdapter;

public class AbstractSwitchWriter {
    protected static void pushSwitchExpression(GeneratorAdapter generatorAdapter, MethodContext context, ExpressionDef expression) {
        TypeDef switchExpressionType = expression.type();
        ExpressionWriter.writeExpressionCheckCast(generatorAdapter, context, expression, switchExpressionType);
        if (!switchExpressionType.equals(TypeDef.Primitive.INT)) {
            throw new UnsupportedOperationException("Not allowed switch expression type: " + String.valueOf(switchExpressionType));
        }
    }

    protected static int toSwitchKey(ExpressionDef.Constant constant) {
        Object object = constant.value();
        if (object instanceof String) {
            String s = (String)object;
            return s.hashCode();
        }
        object = constant.value();
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        throw new UnsupportedOperationException("Unrecognized constant for a switch key: " + String.valueOf(constant));
    }
}

