/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.JsonArrayNodeDecoder;
import io.micronaut.serde.support.util.JsonObjectNodeDecoder;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class JsonNodeDecoder
extends LimitingStream
implements Decoder {
    JsonNodeDecoder(LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    public static JsonNodeDecoder create(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
        return new Buffered(node, remainingLimits);
    }

    protected abstract JsonNode peekValue() throws IOException;

    public Decoder decodeArray(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isArray()) {
            this.skipValue();
            return new JsonArrayNodeDecoder(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", JsonNodeDecoder.toArbitrary(peeked));
    }

    public Decoder decodeObject(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isObject()) {
            this.skipValue();
            return new JsonObjectNodeDecoder(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", JsonNodeDecoder.toArbitrary(peeked));
    }

    public String decodeString() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isString()) {
            this.skipValue();
            return peeked.getStringValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.STRING);){
                String unwrapped = decoder.decodeString();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one string, but got array of multiple values", null);
                }
                String string = unwrapped;
                return string;
            }
        }
        throw this.createDeserializationException("Not a string", JsonNodeDecoder.toArbitrary(peeked));
    }

    public boolean decodeBoolean() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isBoolean()) {
            this.skipValue();
            return peeked.getBooleanValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.BOOLEAN);){
                boolean unwrapped = decoder.decodeBoolean();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one boolean, but got array of multiple values", null);
                }
                boolean bl = unwrapped;
                return bl;
            }
        }
        throw this.createDeserializationException("Not a boolean", JsonNodeDecoder.toArbitrary(peeked));
    }

    public byte decodeByte() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (byte)peeked.getIntValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.BYTE);){
                byte unwrapped = decoder.decodeByte();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one byte, but got array of multiple values", null);
                }
                byte by = unwrapped;
                return by;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public short decodeShort() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (short)peeked.getIntValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.SHORT);){
                short unwrapped = decoder.decodeShort();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one short, but got array of multiple values", null);
                }
                short s = unwrapped;
                return s;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public char decodeChar() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (char)peeked.getIntValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.CHAR);){
                char unwrapped = decoder.decodeChar();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one char, but got array of multiple values", null);
                }
                char c = unwrapped;
                return c;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public int decodeInt() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getIntValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.INT);){
                int unwrapped = decoder.decodeInt();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one int, but got array of multiple values", null);
                }
                int n = unwrapped;
                return n;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public long decodeLong() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getLongValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.LONG);){
                long unwrapped = decoder.decodeLong();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one long, but got array of multiple values", null);
                }
                long l = unwrapped;
                return l;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public float decodeFloat() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getFloatValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.FLOAT);){
                float unwrapped = decoder.decodeFloat();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one float, but got array of multiple values", null);
                }
                float f = unwrapped;
                return f;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public double decodeDouble() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getDoubleValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray(Argument.DOUBLE);){
                double unwrapped = decoder.decodeDouble();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one double, but got array of multiple values", null);
                }
                double d = unwrapped;
                return d;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public BigInteger decodeBigInteger() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigIntegerValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray();){
                BigInteger unwrapped = decoder.decodeBigInteger();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one BigInteger, but got array of multiple values", null);
                }
                BigInteger bigInteger = unwrapped;
                return bigInteger;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public BigDecimal decodeBigDecimal() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigDecimalValue();
        }
        if (peeked.isArray()) {
            try (Decoder decoder = this.decodeArray();){
                BigDecimal unwrapped = decoder.decodeBigDecimal();
                if (decoder.hasNextArrayValue()) {
                    throw this.createDeserializationException("Expected one BigDecimal, but got array of multiple values", null);
                }
                BigDecimal bigDecimal = unwrapped;
                return bigDecimal;
            }
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public byte @NonNull [] decodeBinary() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isString()) {
            return BinaryCodecUtil.decodeFromBase64String((Decoder)this);
        }
        return BinaryCodecUtil.decodeFromArray((Decoder)this);
    }

    public boolean decodeNull() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNull()) {
            this.skipValue();
            return true;
        }
        return false;
    }

    public Object decodeArbitrary() throws IOException {
        return JsonNodeDecoder.toArbitrary(this.decodeNode());
    }

    @NonNull
    public JsonNode decodeNode() throws IOException {
        JsonNode node = this.peekValue();
        this.skipValue();
        return node;
    }

    private static Object toArbitrary(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isNumber()) {
            return node.getNumberValue();
        }
        if (node.isBoolean()) {
            return node.getBooleanValue();
        }
        if (node.isString()) {
            return node.getStringValue();
        }
        if (node.isArray()) {
            ArrayList<Object> transformed = new ArrayList<Object>(node.size());
            for (JsonNode value : node.values()) {
                transformed.add(JsonNodeDecoder.toArbitrary(value));
            }
            return transformed;
        }
        if (node.isObject()) {
            LinkedHashMap transformed = CollectionUtils.newLinkedHashMap((int)node.size());
            for (Map.Entry entry : node.entries()) {
                transformed.put((String)entry.getKey(), JsonNodeDecoder.toArbitrary((JsonNode)entry.getValue()));
            }
            return transformed;
        }
        throw new AssertionError(node);
    }

    public Decoder decodeBuffer() throws IOException {
        JsonNode peeked = this.peekValue();
        this.skipValue();
        return new Buffered(peeked, this.ourLimits());
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message, null, invalidValue);
        }
        return new SerdeException(message);
    }

    static final class Buffered
    extends JsonNodeDecoder {
        private final JsonNode node;
        private boolean complete = false;

        Buffered(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.node = node;
        }

        public boolean hasNextArrayValue() {
            return false;
        }

        public String decodeKey() {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        public void skipValue() {
            if (this.complete) {
                throw new IllegalStateException("Already drained");
            }
            this.complete = true;
        }

        public void finishStructure(boolean consumeLeftElements) {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        @Override
        protected JsonNode peekValue() {
            return this.node;
        }
    }
}

