/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.NumericSupportTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

public final class InstantSerde
extends NumericSupportTemporalSerde<Instant>
implements TemporalSerde<Instant>,
SerdeRegistrar<Instant> {
    private static final TemporalQuery<Instant> QUERY = Instant::from;

    public InstantSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_INSTANT, SerdeConfiguration.NumericTimeUnit.MILLISECONDS);
    }

    @Override
    public TemporalQuery<Instant> query() {
        return QUERY;
    }

    @Override
    protected long getSecondPart(Instant value) {
        return value.getEpochSecond();
    }

    @Override
    protected int getNanoPart(Instant value) {
        return value.getNano();
    }

    @Override
    protected Instant fromNanos(long seconds, int nanos) {
        return Instant.ofEpochSecond(seconds, nanos);
    }

    @Override
    protected DefaultFormattedTemporalSerde<Instant> createSpecific(SerdeConfiguration configuration) {
        return new InstantSerde(configuration);
    }

    @Override
    public Argument<Instant> getType() {
        return Argument.of(Instant.class);
    }
}

