/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.processor.bson;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;

public class BsonDiscriminatorTransformer
implements NamedAnnotationTransformer {
    static final String BSON_DEFAULT_DISCRIMINATOR_PROPERTY_NAME = "_t";

    public String getName() {
        return "org.bson.codecs.pojo.annotations.BsonDiscriminator";
    }

    public List<AnnotationValue<?>> transform(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(SerdeConfig.class);
        builder.member("typeName", annotation.stringValue().orElse("$CLASS_SIMPLE_NAME"));
        String discriminatorPropertyName = annotation.stringValue("key").orElse(BSON_DEFAULT_DISCRIMINATOR_PROPERTY_NAME);
        builder.member("typeProperty", discriminatorPropertyName);
        AnnotationValueBuilder subtypedBuilder = AnnotationValue.builder(SerdeConfig.SerSubtyped.class);
        subtypedBuilder.member("dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_SIMPLE_NAME.name());
        subtypedBuilder.member("dp", discriminatorPropertyName);
        return Arrays.asList(builder.build(), subtypedBuilder.build());
    }
}

