/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.uri;

import io.micronaut.core.annotation.Internal;
import java.util.BitSet;
import java.util.Locale;

@Internal
final class PercentEncoder {
    static final PercentEncoder C0 = new PercentEncoder(new BitSet());
    static final PercentEncoder FRAGMENT;
    static final PercentEncoder QUERY;
    static final PercentEncoder SPECIAL_QUERY;
    static final PercentEncoder PATH;
    static final PercentEncoder USERINFO;
    static final PercentEncoder COMPONENT;
    static final PercentEncoder FORM;
    static final PercentEncoder RFC3986_UNRESERVED;
    static final PercentEncoder RFC3986_PCHAR;
    static final PercentEncoder RFC3986_QUERY_CHAR;
    private final BitSet keepSet;

    private PercentEncoder(BitSet keepSet) {
        this.keepSet = keepSet;
    }

    public void encodeByte(StringBuilder target, byte b) {
        if (this.keep(b)) {
            target.append((char)(b & 0xFF));
        } else {
            target.ensureCapacity(target.length() + 3);
            PercentEncoder.appendEncodedByte(target, b);
        }
    }

    public boolean keep(byte b) {
        return this.keepSet.get(b & 0xFF);
    }

    public void encodeUtf8(StringBuilder target, int codePoint) {
        if (codePoint < 128) {
            if (this.keepSet.get(codePoint)) {
                target.append((char)codePoint);
            } else {
                target.ensureCapacity(target.length() + 3);
                PercentEncoder.appendEncodedByte(target, (byte)codePoint);
            }
        } else if (codePoint < 2048) {
            target.ensureCapacity(target.length() + 6);
            PercentEncoder.appendEncodedByte(target, (byte)(0xC0 | codePoint >> 6));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint & 0x3F));
        } else if (codePoint < 65536) {
            target.ensureCapacity(target.length() + 9);
            PercentEncoder.appendEncodedByte(target, (byte)(0xE0 | codePoint >> 12));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint >> 6 & 0x3F));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint & 0x3F));
        } else if (codePoint < 0x110000) {
            target.ensureCapacity(target.length() + 12);
            PercentEncoder.appendEncodedByte(target, (byte)(0xF0 | codePoint >> 18));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint >> 12 & 0x3F));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint >> 6 & 0x3F));
            PercentEncoder.appendEncodedByte(target, (byte)(0x80 | codePoint & 0x3F));
        } else {
            throw new IllegalArgumentException("Code point out of range: " + codePoint);
        }
    }

    static void appendEncodedByte(StringBuilder target, byte b) {
        target.append('%');
        if ((b & 0xFF) < 16) {
            target.append('0');
        }
        target.append(Integer.toHexString(b & 0xFF).toUpperCase(Locale.ROOT));
    }

    private PercentEncoder addEncode(char ... removed) {
        BitSet result = (BitSet)this.keepSet.clone();
        for (char c : removed) {
            result.clear(c);
        }
        return new PercentEncoder(result);
    }

    private PercentEncoder addEncodeRange(char fromInclusive, char toExclusive) {
        BitSet result = (BitSet)this.keepSet.clone();
        for (char c = fromInclusive; c <= toExclusive; c = (char)(c + '\u0001')) {
            result.clear(c);
        }
        return new PercentEncoder(result);
    }

    private PercentEncoder removeEncode(char ... removed) {
        BitSet result = (BitSet)this.keepSet.clone();
        for (char c : removed) {
            result.set(c);
        }
        return new PercentEncoder(result);
    }

    private PercentEncoder removeEncodeRange(char fromInclusive, char toExclusive) {
        BitSet result = (BitSet)this.keepSet.clone();
        for (char c = fromInclusive; c <= toExclusive; c = (char)(c + '\u0001')) {
            result.set(c);
        }
        return new PercentEncoder(result);
    }

    static {
        for (int c = 32; c <= 126; c = (int)((char)(c + 1))) {
            PercentEncoder.C0.keepSet.set(c);
        }
        FRAGMENT = C0.addEncode(' ', '\"', '<', '>', '`');
        QUERY = C0.addEncode(' ', '\"', '<', '>', '#');
        SPECIAL_QUERY = QUERY.addEncode('\'');
        PATH = QUERY.addEncode('?', '`', '{', '}');
        USERINFO = PATH.addEncode('/', ':', ';', '=', '@', '|').addEncodeRange('[', '^');
        COMPONENT = USERINFO.addEncode('+', ',').addEncodeRange('$', '&');
        FORM = COMPONENT.addEncode('!', '~').addEncodeRange('\'', ')');
        RFC3986_UNRESERVED = new PercentEncoder(new BitSet()).removeEncodeRange('a', 'z').removeEncodeRange('A', 'Z').removeEncodeRange('0', '9').removeEncode('-', '.', '_', '~');
        RFC3986_PCHAR = RFC3986_UNRESERVED.removeEncode('%', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '@');
        RFC3986_QUERY_CHAR = RFC3986_PCHAR.removeEncode('/', '?');
    }
}

