/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.UriRouteInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface UriRouteMatch<T, R>
extends UriMatchInfo,
MethodBasedRouteMatch<T, R> {
    public UriRouteInfo<T, R> getRouteInfo();

    @Override
    default public List<Argument<?>> getRequiredArguments() {
        Object[] arguments = this.getArguments();
        if (ArrayUtils.isNotEmpty((Object[])arguments)) {
            Map matchVariables = this.getVariableValues();
            ArrayList actualArguments = new ArrayList(arguments.length);
            for (Object argument : arguments) {
                if (matchVariables.containsKey(argument.getName())) continue;
                actualArguments.add((Argument<?>)argument);
            }
            return actualArguments;
        }
        return Collections.emptyList();
    }

    public HttpMethod getHttpMethod();
}

