/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.AnsiColour;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.QualifiedBeanType;
import io.micronaut.inject.proxy.InterceptedBean;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface BeanDefinition<T>
extends QualifiedBeanType<T>,
Named,
BeanType<T>,
ArgumentCoercible<T> {
    @NonNull
    default public TypeInformation<T> getTypeInformation() {
        return new TypeInformation<T>(){

            public String getBeanTypeString(TypeInformation.TypeFormat format) {
                Class beanType = this.getType();
                boolean synthetic = beanType.isSynthetic();
                if (synthetic) {
                    AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
                    if (annotationMetadata.hasDeclaredStereotype("io.micronaut.aop.Adapter")) {
                        ExecutableMethod method = BeanDefinition.this.getExecutableMethods().iterator().next();
                        Class resolvedBeanType = method.classValue("io.micronaut.aop.Adapter", "adaptedBean").orElse(beanType);
                        return TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)format, resolvedBeanType, (Map)BeanDefinition.this.getGenericBeanType().getTypeVariables(), (AnnotationMetadata)annotationMetadata);
                    }
                    if (InterceptedBean.class.isAssignableFrom(beanType)) {
                        if (beanType.isInterface()) {
                            return TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)format, beanType.getInterfaces()[0], (Map)BeanDefinition.this.getGenericBeanType().getTypeVariables(), (AnnotationMetadata)annotationMetadata);
                        }
                        return TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)format, beanType.getSuperclass(), (Map)BeanDefinition.this.getGenericBeanType().getTypeVariables(), (AnnotationMetadata)annotationMetadata);
                    }
                    return super.getBeanTypeString(format);
                }
                return super.getBeanTypeString(format);
            }

            public Class<T> getType() {
                return BeanDefinition.this.getBeanType();
            }

            public Map<String, Argument<?>> getTypeVariables() {
                return BeanDefinition.this.getGenericBeanType().getTypeVariables();
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return BeanDefinition.this.getAnnotationMetadata();
            }
        };
    }

    default public Optional<Class<? extends Annotation>> getScope() {
        return Optional.empty();
    }

    default public Optional<String> getScopeName() {
        return Optional.empty();
    }

    default public boolean isSingleton() {
        String scopeName = this.getScopeName().orElse(null);
        if (scopeName != null && scopeName.equals("jakarta.inject.Singleton")) {
            return true;
        }
        return this.getAnnotationMetadata().stringValue(DefaultScope.class).map(t -> t.equals(Singleton.class.getName()) || t.equals("jakarta.inject.Singleton")).orElse(false);
    }

    default public Optional<Argument<?>> getContainerElement() {
        return Optional.empty();
    }

    @Override
    default public boolean isCandidateBean(@Nullable Argument<?> beanType) {
        if (beanType == null) {
            return false;
        }
        if (QualifiedBeanType.super.isCandidateBean(beanType)) {
            Optional<Argument<?>> containerElement;
            Argument[] typeArguments = beanType.getTypeParameters();
            int len = typeArguments.length;
            Class beanClass = beanType.getType();
            if (len == 0) {
                if (this.isContainerType()) {
                    if (this.getBeanType().isAssignableFrom(beanClass)) {
                        return true;
                    }
                    Optional<Argument<?>> containerElement2 = this.getContainerElement();
                    if (containerElement2.isPresent()) {
                        Class t = containerElement2.get().getType();
                        return beanType.isAssignableFrom(t) || beanClass == t;
                    }
                    return false;
                }
                return true;
            }
            Argument[] beanTypeParameters = !Iterable.class.isAssignableFrom(beanClass) ? ((containerElement = this.getContainerElement()).isPresent() ? containerElement.get().getTypeParameters() : this.getTypeArguments(beanClass).toArray(Argument.ZERO_ARGUMENTS)) : this.getTypeArguments(beanClass).toArray(Argument.ZERO_ARGUMENTS);
            if (len != beanTypeParameters.length) {
                return false;
            }
            for (int i = 0; i < beanTypeParameters.length; ++i) {
                Argument requestedParameter = typeArguments[i];
                Argument candidateParameter = beanTypeParameters[i];
                if (requestedParameter.isAssignableFrom(candidateParameter.getType()) || candidateParameter.isTypeVariable() && candidateParameter.isAssignableFrom(requestedParameter.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public boolean isIterable() {
        return this.hasDeclaredStereotype(EachProperty.class) || this.hasDeclaredStereotype(EachBean.class);
    }

    default public boolean isConfigurationProperties() {
        return this.isIterable() || this.hasDeclaredStereotype(ConfigurationReader.class);
    }

    @Override
    public Class<T> getBeanType();

    default public Optional<Class<?>> getDeclaringType() {
        return Optional.empty();
    }

    default public ConstructorInjectionPoint<T> getConstructor() {
        return new ConstructorInjectionPoint<T>(){

            @Override
            public Argument<?>[] getArguments() {
                return Argument.ZERO_ARGUMENTS;
            }

            @Override
            public BeanDefinition<T> getDeclaringBean() {
                return BeanDefinition.this;
            }

            public String toString() {
                return this.getDeclaringBeanType().getName() + "(" + Argument.toString(this.getArguments()) + ")";
            }
        };
    }

    default public Collection<Class<?>> getRequiredComponents() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getInjectedMethods() {
        return Collections.emptyList();
    }

    default public Collection<FieldInjectionPoint<T, ?>> getInjectedFields() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getPostConstructMethods() {
        return Collections.emptyList();
    }

    default public Collection<MethodInjectionPoint<T, ?>> getPreDestroyMethods() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public String getName() {
        return this.getBeanType().getName();
    }

    default public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class<?> ... argumentTypes) {
        return Optional.empty();
    }

    default public boolean hasAnnotatedMethod(@NonNull Class<? extends Annotation> annotationClass, @NonNull String methodName, Class<?> ... argumentTypes) {
        return this.findMethod(methodName, argumentTypes).map(method -> method.hasAnnotation(annotationClass)).orElse(false);
    }

    default public <R> Stream<ExecutableMethod<T, R>> findPossibleMethods(String name) {
        return Stream.empty();
    }

    default public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        return Collections.emptyList();
    }

    @NonNull
    default public Argument<T> asArgument() {
        return Argument.of(this.getBeanType(), (AnnotationMetadata)this.getAnnotationMetadata(), (Class[])this.getTypeParameters());
    }

    default public boolean isProxy() {
        return false;
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments() {
        return this.getTypeArguments(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(Class<?> type) {
        if (type == null) {
            return Collections.emptyList();
        }
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Class<?>[] getTypeParameters(@Nullable Class<?> type) {
        if (type == null) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        List<Argument<?>> typeArguments = this.getTypeArguments(type);
        if (typeArguments.isEmpty()) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] params = new Class[typeArguments.size()];
        int i = 0;
        for (Argument<?> argument : typeArguments) {
            params[i++] = argument.getType();
        }
        return params;
    }

    @NonNull
    default public Class<?>[] getTypeParameters() {
        return this.getTypeParameters(this.getBeanType());
    }

    @NonNull
    default public List<Argument<?>> getTypeArguments(String type) {
        return Collections.emptyList();
    }

    default public <R> ExecutableMethod<T, R> getRequiredMethod(String name, Class<?> ... argumentTypes) {
        return this.findMethod(name, argumentTypes).orElseThrow(() -> ReflectionUtils.newNoSuchMethodError(this.getBeanType(), (String)name, (Class[])argumentTypes));
    }

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getBeanType().getModifiers());
    }

    default public Argument<T> getGenericBeanType() {
        return this.asArgument();
    }

    @Override
    @Nullable
    default public Qualifier<T> getDeclaredQualifier() {
        return QualifiedBeanType.super.getDeclaredQualifier();
    }

    @Override
    @Nullable
    default public Qualifier<T> resolveDynamicQualifier() {
        return QualifiedBeanType.super.resolveDynamicQualifier();
    }

    @NonNull
    default public String getBeanDescription(@NonNull TypeInformation.TypeFormat typeFormat, boolean includeArguments) {
        ConstructorInjectionPoint<T> constructor = this.getConstructor();
        StringBuilder beanDescription = new StringBuilder();
        Argument<?>[] arguments = constructor.getArguments();
        if (constructor instanceof MethodInjectionPoint) {
            MethodInjectionPoint methodInjectionPoint = (MethodInjectionPoint)((Object)constructor);
            Class declaringType = methodInjectionPoint.getDeclaringType();
            Class<T> declaringBeanType = constructor.getDeclaringBeanType();
            String factoryType = TypeInformation.TypeFormat.getTypeString((TypeInformation.TypeFormat)typeFormat, declaringBeanType, Map.of());
            String beanTypeName = TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, declaringType, (Map)this.asArgument().getTypeVariables(), (AnnotationMetadata)methodInjectionPoint.getAnnotationMetadata());
            beanDescription.append(beanTypeName).append(" ");
            beanDescription.append(factoryType).append(".").append(methodInjectionPoint.getName());
        } else {
            if (constructor instanceof FieldInjectionPoint) {
                FieldInjectionPoint fieldInjectionPoint = (FieldInjectionPoint)((Object)constructor);
                Class<T> declaringBeanType = constructor.getDeclaringBeanType();
                String factoryType = TypeInformation.TypeFormat.getTypeString((TypeInformation.TypeFormat)typeFormat, declaringBeanType, Map.of());
                Class declaringType = fieldInjectionPoint.getDeclaringBean().getBeanType();
                String beanTypeName = TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, declaringType, (Map)this.asArgument().getTypeVariables(), (AnnotationMetadata)fieldInjectionPoint.getAnnotationMetadata());
                beanDescription.append(beanTypeName).append(" ");
                beanDescription.append(factoryType).append(".").append(fieldInjectionPoint.getName());
                return beanDescription.toString();
            }
            boolean synthetic = this.getBeanType().isSynthetic();
            if (synthetic) {
                AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
                if (annotationMetadata.hasDeclaredStereotype("io.micronaut.aop.Adapter")) {
                    ExecutableMethod<T, ?> method = this.getExecutableMethods().iterator().next();
                    Class<T> adaptedType = method.classValue("io.micronaut.aop.Adapter").orElse(this.getBeanType());
                    Class<T> beanType = method.classValue("io.micronaut.aop.Adapter", "adaptedBean").orElse(this.getBeanType());
                    String beanMethod = method.stringValue("io.micronaut.aop.Adapter", "adaptedMethod").orElse("unknown");
                    String beanTypeString = TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, beanType, (Map)this.asArgument().getTypeVariables(), (AnnotationMetadata)annotationMetadata);
                    beanDescription.append(beanTypeString).append(".").append(beanMethod);
                    @NonNull Argument[] methodArguments = method.getArguments();
                    List<Argument<T>> typeArguments = this.getTypeArguments(adaptedType);
                    if (typeArguments.size() == methodArguments.length) {
                        arguments = new Argument[methodArguments.length];
                        for (int i = 0; i < methodArguments.length; ++i) {
                            Argument methodArgument = methodArguments[i];
                            Argument<T> t = typeArguments.get(i);
                            arguments[i] = Argument.of((Class)t.getType(), (String)methodArgument.getName(), (AnnotationMetadata)methodArgument.getAnnotationMetadata(), (Argument[])t.getTypeParameters());
                        }
                    }
                } else {
                    Class<T> beanType = this.getBeanType();
                    String beanTypeString = beanType.isInterface() ? TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, beanType.getInterfaces()[0], (Map)this.asArgument().getTypeVariables(), (AnnotationMetadata)annotationMetadata) : TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, beanType.getSuperclass(), (Map)this.asArgument().getTypeVariables(), (AnnotationMetadata)annotationMetadata);
                    beanDescription.append(beanTypeString);
                }
            } else {
                beanDescription.append(this.getTypeInformation().getBeanTypeString(typeFormat));
            }
        }
        if (includeArguments) {
            beanDescription.append(typeFormat.isAnsi() ? AnsiColour.brightCyan((String)"(") : "(");
            for (int i = 0; i < arguments.length; ++i) {
                Argument<?> argument = arguments[i];
                if (argument.getName().startsWith("$")) continue;
                String argType = TypeInformation.TypeFormat.getBeanTypeString((TypeInformation.TypeFormat)typeFormat, argument);
                String argumentName = argument.getName();
                beanDescription.append(argType).append(" ").append(typeFormat.isAnsi() ? AnsiColour.brightBlue((String)argumentName) : argumentName);
                if (i == arguments.length - 1) continue;
                Argument<?> next = arguments[i + 1];
                if (this.getBeanType().isSynthetic() && next.getName().startsWith("$")) break;
                beanDescription.append(", ");
            }
            beanDescription.append(typeFormat.isAnsi() ? AnsiColour.brightCyan((String)")") : ")");
        }
        return beanDescription.toString();
    }

    @NonNull
    default public String getBeanDescription(@NonNull TypeInformation.TypeFormat typeFormat) {
        return this.getBeanDescription(typeFormat, true);
    }
}

