/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.DefaultOrigin;
import io.micronaut.context.env.MapPropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public interface PropertySource
extends Iterable<String>,
Ordered {
    public static final String CONTEXT = "context";

    public String getName();

    public Object get(String var1);

    @NonNull
    default public Origin getOrigin() {
        return Origin.of(this.getName());
    }

    default public PropertyConvention getConvention() {
        return PropertyConvention.JAVA_PROPERTIES;
    }

    public static PropertySource of(String name, Map<String, Object> map) {
        return new MapPropertySource(name, map);
    }

    public static PropertySource of(String name, Map<String, Object> map, final Origin origin) {
        return new MapPropertySource(name, map){

            @Override
            public Origin getOrigin() {
                return origin != null ? origin : super.getOrigin();
            }
        };
    }

    @Deprecated(forRemoval=true, since="4.8.0")
    public static PropertySource of(String name, Map<String, Object> map, final PropertyConvention convention) {
        return new MapPropertySource(name, map){

            @Override
            public PropertyConvention getConvention() {
                return convention;
            }
        };
    }

    public static PropertySource of(String name, Map<String, Object> map, final PropertyConvention convention, final Origin origin) {
        return new MapPropertySource(name, map){

            @Override
            public PropertyConvention getConvention() {
                return convention;
            }

            @Override
            public Origin getOrigin() {
                return origin != null ? origin : super.getOrigin();
            }
        };
    }

    @Deprecated(forRemoval=true)
    public static PropertySource of(String name, Object ... values) {
        return new MapPropertySource(name, PropertySource.mapOf(values));
    }

    public static Map<String, Object> mapOf(Object ... values) {
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>(len / 2);
        int i = 0;
        while (i < values.length - 1) {
            Object k;
            if ((k = values[i++]) == null) continue;
            answer.put(k.toString(), values[i++]);
        }
        return answer;
    }

    public static PropertySource of(String name, Map<String, Object> map, final int priority) {
        return new MapPropertySource(name, map){

            public int getOrder() {
                return priority;
            }
        };
    }

    public static PropertySource of(String name, Map<String, Object> map, final Origin origin, final int priority) {
        return new MapPropertySource(name, map){

            public int getOrder() {
                return priority;
            }

            @Override
            public Origin getOrigin() {
                return origin != null ? origin : super.getOrigin();
            }
        };
    }

    public static PropertySource of(Map<String, Object> map) {
        return new MapPropertySource("application", map);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Origin {
        public String location();

        @NonNull
        public static Origin of(@NonNull String location) {
            Objects.requireNonNull(location, "Location cannot be null");
            return new DefaultOrigin(location);
        }
    }

    public static enum PropertyConvention {
        ENVIRONMENT_VARIABLE,
        JAVA_PROPERTIES;

    }
}

