/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaNativeElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaFieldElement
extends AbstractJavaElement
implements FieldElement {
    private final VariableElement variableElement;
    private JavaClassElement owningType;
    private ClassElement type;
    private ClassElement genericType;
    private ClassElement resolvedDeclaringClass;

    JavaFieldElement(JavaNativeElement.Variable nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        super(nativeElement, annotationMetadataFactory, visitorContext);
        this.variableElement = nativeElement.element();
    }

    JavaFieldElement(JavaClassElement owningType, JavaNativeElement.Variable nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, JavaVisitorContext visitorContext) {
        this(nativeElement, annotationMetadataFactory, visitorContext);
        this.owningType = owningType;
    }

    @Override
    @NonNull
    public JavaNativeElement.Variable getNativeType() {
        return (JavaNativeElement.Variable)super.getNativeType();
    }

    @Override
    protected AbstractJavaElement copyThis() {
        return new JavaFieldElement(this.owningType, this.getNativeType(), this.elementAnnotationMetadataFactory, this.visitorContext);
    }

    public FieldElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (FieldElement)super.withAnnotationMetadata(annotationMetadata);
    }

    public Object getConstantValue() {
        return this.variableElement.getConstantValue();
    }

    @NonNull
    public ClassElement getType() {
        if (this.type == null) {
            this.type = this.newClassElement(this.getNativeType(), this.variableElement.asType(), Collections.emptyMap());
        }
        return this.type;
    }

    @NonNull
    public ClassElement getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.newClassElement(this.getNativeType(), this.variableElement.asType(), this.getDeclaringType().getTypeArguments());
        }
        return this.genericType;
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public int getArrayDimensions() {
        return this.getType().getArrayDimensions();
    }

    public ClassElement getDeclaringType() {
        if (this.resolvedDeclaringClass == null) {
            Element enclosingElement = this.variableElement.getEnclosingElement();
            if (enclosingElement instanceof TypeElement) {
                TypeElement te = (TypeElement)enclosingElement;
                String typeName = JavaModelUtils.getClassName((TypeElement)te);
                if (this.owningType.getName().equals(JavaModelUtils.getClassName((TypeElement)te))) {
                    this.resolvedDeclaringClass = this.owningType;
                } else {
                    TypeMirror returnType = te.asType();
                    Map genericsInfo = this.owningType.getTypeArguments(typeName);
                    this.resolvedDeclaringClass = this.newClassElement(returnType, genericsInfo);
                }
            } else {
                return this.owningType;
            }
        }
        return this.resolvedDeclaringClass;
    }

    public boolean hides(@NonNull MemberElement hidden) {
        if (this.isStatic() && this.getDeclaringType().isInterface()) {
            return false;
        }
        return this.visitorContext.getElements().hides(this.getNativeType().element(), ((JavaNativeElement.Variable)hidden.getNativeType()).element());
    }

    public ClassElement getOwningType() {
        return this.owningType;
    }
}

