/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.quic.QuicTokenHandler;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.InetSocketAddress;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;

@Internal
class QuicTokenHandlerImpl
implements QuicTokenHandler {
    private static final int MAC_LENGTH = 32;
    private static final int MAX_CONNECTION_ID_LENGTH = 20;
    private static final long TIMESTAMP_WINDOW_SIZE = 300000L;
    private final Key key;
    private final FastThreadLocal<Mac> macCache = new FastThreadLocal<Mac>(){

        protected Mac initialValue() throws Exception {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(QuicTokenHandlerImpl.this.key);
            return mac;
        }
    };
    private final ByteBufAllocator alloc;

    QuicTokenHandlerImpl(ByteBufAllocator alloc) {
        this.alloc = alloc;
        try {
            this.key = KeyGenerator.getInstance("HmacSHA256").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    static QuicTokenHandler create(ByteBufAllocator alloc) {
        return new QuicTokenHandlerImpl(alloc);
    }

    public boolean writeToken(ByteBuf out, ByteBuf dcid, InetSocketAddress address) {
        byte[] hash = this.hash(address, dcid, this.currentWindowId());
        out.writeBytes(hash);
        out.writeBytes(dcid, dcid.readerIndex(), dcid.readableBytes());
        return true;
    }

    public int validateToken(ByteBuf token, InetSocketAddress address) {
        byte[] actual = new byte[32];
        token.getBytes(token.readerIndex(), actual);
        ByteBuf dcid = token.slice(token.readerIndex() + 32, token.readableBytes() - 32);
        long windowId = this.currentWindowId();
        byte[] expectedHashNow = this.hash(address, dcid, windowId);
        byte[] expectedHashPrev = this.hash(address, dcid, windowId - 1L);
        boolean equalNow = MessageDigest.isEqual(expectedHashNow, actual);
        boolean equalPrev = MessageDigest.isEqual(expectedHashPrev, actual);
        if (equalNow | equalPrev) {
            return 32;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] hash(InetSocketAddress address, ByteBuf dcid, long windowId) {
        byte[] hash;
        ByteBuf textToVerify = this.buildTextToVerify(address, dcid, windowId);
        try {
            Mac mac = (Mac)this.macCache.get();
            mac.update(textToVerify.array(), textToVerify.arrayOffset() + textToVerify.readerIndex(), textToVerify.readableBytes());
            hash = mac.doFinal();
        }
        finally {
            textToVerify.release();
        }
        assert (hash.length == 32);
        return hash;
    }

    private ByteBuf buildTextToVerify(InetSocketAddress address, ByteBuf dcid, long windowId) {
        if (dcid.readableBytes() > 20) {
            throw new IllegalArgumentException("Connection ID may not exceed 20 bytes length");
        }
        ByteBuf textToVerify = this.alloc.heapBuffer();
        byte[] addressBytes = address.getAddress().getAddress();
        textToVerify.writeByte(addressBytes.length);
        textToVerify.writeBytes(addressBytes);
        textToVerify.writeShort(address.getPort());
        textToVerify.writeByte(dcid.readableBytes());
        textToVerify.writeBytes(dcid, dcid.readerIndex(), dcid.readableBytes());
        textToVerify.writeLong(windowId);
        return textToVerify;
    }

    public int maxTokenLength() {
        return 52;
    }

    long currentWindowId() {
        return System.currentTimeMillis() / 300000L;
    }
}

