/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.ssl.SslConfiguration;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import io.netty.handler.ssl.SslProvider;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;

@Internal
public final class NettyTlsUtils {
    private static boolean useOpenssl(SslConfiguration sslConfiguration) {
        return sslConfiguration.isPreferOpenssl() && SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL_REFCNT);
    }

    public static SslProvider sslProvider(SslConfiguration sslConfiguration) {
        return NettyTlsUtils.useOpenssl(sslConfiguration) ? SslProvider.OPENSSL_REFCNT : SslProvider.JDK;
    }

    @NonNull
    public static KeyManagerFactory storeToFactory(@NonNull SslConfiguration ssl, @Nullable KeyStore keyStore) throws Exception {
        Object keyManagerFactory = NettyTlsUtils.useOpenssl(ssl) ? (keyStore == null || keyStore.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()))) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        Optional password = ssl.getKey().getPassword();
        char[] keyPassword = password.map(String::toCharArray).orElse(null);
        Optional pwd = ssl.getKeyStore().getPassword();
        if (keyPassword == null && pwd.isPresent()) {
            keyPassword = ((String)pwd.get()).toCharArray();
        }
        if (keyStore != null && ssl.getKey().getAlias().isPresent()) {
            keyStore = NettyTlsUtils.extractKeystoreAlias(keyStore, (String)ssl.getKey().getAlias().get(), keyPassword);
        }
        ((KeyManagerFactory)keyManagerFactory).init(keyStore, keyPassword);
        return keyManagerFactory;
    }

    @NonNull
    private static KeyStore extractKeystoreAlias(@NonNull KeyStore rootKeystore, @NonNull String alias, @Nullable char[] password) throws Exception {
        if (!rootKeystore.containsAlias(alias)) {
            throw new IllegalArgumentException("Alias " + alias + " not found in keystore");
        }
        Key key = rootKeystore.getKey(alias, password);
        if (key == null) {
            throw new IllegalStateException("There are no keys associated with the alias " + alias);
        }
        Certificate[] certChain = rootKeystore.getCertificateChain(alias);
        KeyStore aliasKeystore = KeyStore.getInstance(rootKeystore.getType());
        aliasKeystore.load(null, null);
        aliasKeystore.setKeyEntry(alias, key, password, certChain);
        return aliasKeystore;
    }
}

