/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.buffer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

@Internal
public class DelegateByteBuffer<T>
implements ByteBuffer<T> {
    private final ByteBuffer<T> delegate;

    public DelegateByteBuffer(ByteBuffer<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T asNativeBuffer() {
        return this.delegate.asNativeBuffer();
    }

    @Override
    public int readableBytes() {
        return this.delegate.readableBytes();
    }

    @Override
    public int writableBytes() {
        return this.delegate.writableBytes();
    }

    @Override
    public int maxCapacity() {
        return this.delegate.maxCapacity();
    }

    @Override
    public ByteBuffer capacity(int capacity) {
        this.delegate.capacity(capacity);
        return this;
    }

    @Override
    public int readerIndex() {
        return this.delegate.readerIndex();
    }

    @Override
    public ByteBuffer readerIndex(int readPosition) {
        this.delegate.readerIndex(readPosition);
        return this;
    }

    @Override
    public int writerIndex() {
        return this.delegate.writerIndex();
    }

    @Override
    public ByteBuffer writerIndex(int position) {
        this.delegate.writerIndex(position);
        return this;
    }

    @Override
    public byte read() {
        return this.delegate.read();
    }

    @Override
    public CharSequence readCharSequence(int length, Charset charset) {
        return this.delegate.readCharSequence(length, charset);
    }

    @Override
    public ByteBuffer read(byte[] destination) {
        this.delegate.read(destination);
        return this;
    }

    @Override
    public ByteBuffer read(byte[] destination, int offset, int length) {
        this.delegate.read(destination, offset, length);
        return this;
    }

    @Override
    public ByteBuffer write(byte b) {
        this.delegate.write(b);
        return this;
    }

    @Override
    public ByteBuffer write(byte[] source) {
        this.delegate.write(source);
        return this;
    }

    @Override
    public ByteBuffer write(CharSequence source, Charset charset) {
        this.delegate.write(source, charset);
        return this;
    }

    @Override
    public ByteBuffer write(byte[] source, int offset, int length) {
        this.delegate.write(source, offset, length);
        return this;
    }

    @Override
    public ByteBuffer write(ByteBuffer ... buffers) {
        this.delegate.write(buffers);
        return this;
    }

    @Override
    public ByteBuffer write(java.nio.ByteBuffer ... buffers) {
        this.delegate.write(buffers);
        return this;
    }

    @Override
    public ByteBuffer slice(int index, int length) {
        this.delegate.slice(index, length);
        return this;
    }

    @Override
    public java.nio.ByteBuffer asNioBuffer() {
        return this.delegate.asNioBuffer();
    }

    @Override
    public java.nio.ByteBuffer asNioBuffer(int index, int length) {
        return this.delegate.asNioBuffer(index, length);
    }

    @Override
    public InputStream toInputStream() {
        return this.delegate.toInputStream();
    }

    @Override
    public OutputStream toOutputStream() {
        return this.delegate.toOutputStream();
    }

    @Override
    public byte[] toByteArray() {
        return this.delegate.toByteArray();
    }

    @Override
    public String toString(Charset charset) {
        return this.delegate.toString(charset);
    }

    @Override
    public int indexOf(byte b) {
        return this.delegate.indexOf(b);
    }

    @Override
    public byte getByte(int index) {
        return this.delegate.getByte(index);
    }
}

