/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.execution;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.execution.ImperativeExecutionFlow;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DelayedExecutionFlowImpl<T>
implements DelayedExecutionFlow<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedExecutionFlowImpl.class);
    private static final AtomicReferenceFieldUpdater<DelayedExecutionFlowImpl, Head> HEAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DelayedExecutionFlowImpl.class, Head.class, "head");
    private volatile Head head = new Head();
    private Step tail = this.head;
    private Runnable onCancel;
    private volatile boolean cancelled;

    DelayedExecutionFlowImpl() {
    }

    private static void work(Step step, ExecutionFlow<Object> executionFlow) {
        while ((step = step.atomicSetOutput(executionFlow = step.apply(executionFlow))) != null) {
        }
    }

    @Override
    public void completeFrom(@NonNull ExecutionFlow<T> flow) {
        flow.onComplete(this::complete);
    }

    private void completeLazy(@NonNull ExecutionFlow<Object> executionFlow) {
        if (this.head == null) {
            throw new IllegalStateException("Delayed flow has been completed");
        }
        Step immediateStep = this.head.atomicSetOutput(executionFlow);
        if (immediateStep != null) {
            DelayedExecutionFlowImpl.work(immediateStep, executionFlow);
        }
        this.head = null;
    }

    private boolean completeAtomic(@NonNull ExecutionFlow<Object> executionFlow) {
        Head head = HEAD_UPDATER.getAndSet(this, null);
        if (head == null) {
            return false;
        }
        Step immediateStep = head.atomicSetOutput(executionFlow);
        if (immediateStep != null) {
            DelayedExecutionFlowImpl.work(immediateStep, executionFlow);
        }
        return true;
    }

    @Override
    public void complete(T result) {
        this.completeLazy(result == null ? ExecutionFlow.empty() : ExecutionFlow.just(result));
    }

    @Override
    public void completeExceptionally(Throwable exc) {
        this.completeLazy(ExecutionFlow.error(exc));
    }

    @Override
    public boolean tryComplete(@Nullable T result) {
        return this.completeAtomic(result == null ? ExecutionFlow.empty() : ExecutionFlow.just(result));
    }

    @Override
    public boolean tryCompleteExceptionally(Throwable exc) {
        return this.completeAtomic(ExecutionFlow.error(exc));
    }

    private <R> ExecutionFlow<R> next(Step next) {
        Step oldTail = this.tail;
        if (oldTail instanceof Cancel) {
            throw new IllegalStateException("Cannot add more ExecutionFlow steps after cancellation");
        }
        this.tail = next;
        ExecutionFlow<Object> output = oldTail.atomicSetNext(next);
        if (output != null) {
            DelayedExecutionFlowImpl.work(next, output);
        }
        return this;
    }

    @Override
    public <R> ExecutionFlow<R> map(Function<? super T, ? extends R> transformer) {
        return this.next(new Map<T, R>(transformer));
    }

    @Override
    public <R> ExecutionFlow<R> flatMap(Function<? super T, ? extends ExecutionFlow<? extends R>> transformer) {
        return this.next(new FlatMap(transformer));
    }

    @Override
    public <R> ExecutionFlow<R> then(Supplier<? extends ExecutionFlow<? extends R>> supplier) {
        return this.next(new Then(supplier));
    }

    @Override
    public ExecutionFlow<T> onErrorResume(Function<? super Throwable, ? extends ExecutionFlow<? extends T>> fallback) {
        return this.next(new OnErrorResume(fallback));
    }

    @Override
    public ExecutionFlow<T> putInContext(String key, Object value) {
        return this;
    }

    @Override
    public void onComplete(BiConsumer<? super T, Throwable> fn) {
        this.next(new OnComplete<T>(fn));
    }

    @Override
    public void completeTo(CompletableFuture<T> completableFuture) {
        this.next(new OnCompleteToFuture<T>(completableFuture));
    }

    @Override
    @Nullable
    public ImperativeExecutionFlow<T> tryComplete() {
        ExecutionFlow<Object> tailOutput = this.tail.output;
        if (tailOutput != null) {
            return tailOutput.tryComplete();
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.next(new Cancel());
        this.cancelled = true;
        Runnable hook = this.onCancel;
        if (hook != null) {
            hook.run();
        }
    }

    @Override
    public void onCancel(Runnable hook) {
        Runnable prev = this.onCancel;
        this.onCancel = prev != null ? () -> {
            prev.run();
            hook.run();
        } : hook;
    }

    private static final class Head
    extends Step<Object, Object> {
        private Head() {
        }

        @Override
        ExecutionFlow<Object> apply(ExecutionFlow<Object> input) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class Step<I, O> {
        private volatile Step next;
        private volatile ExecutionFlow<Object> output;

        private Step() {
        }

        abstract ExecutionFlow<O> apply(ExecutionFlow<I> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        final Step atomicSetOutput(ExecutionFlow<Object> output) {
            if (this.output != null) {
                throw new IllegalStateException("Already completed");
            }
            Step next = this.next;
            if (next != null) {
                return next;
            }
            this.output = output;
            next = this.next;
            if (next != null) {
                Step step = this;
                synchronized (step) {
                    next = this.next;
                    if (next != null) {
                        this.output = null;
                        return next;
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        final ExecutionFlow<Object> atomicSetNext(Step next) {
            if (this.next != null) {
                throw new IllegalStateException("Already added a next step");
            }
            ExecutionFlow<Object> output = this.output;
            if (output != null) {
                return output;
            }
            this.next = next;
            output = this.output;
            if (output != null) {
                Step step = this;
                synchronized (step) {
                    output = this.output;
                    if (output != null) {
                        this.next = null;
                        return output;
                    }
                }
            }
            return null;
        }

        final <O> ExecutionFlow<O> returnError(Throwable e) {
            return ExecutionFlow.error(e);
        }
    }

    private static final class Cancel<E>
    extends Step<E, E> {
        private static final ExecutionFlow ERR = ExecutionFlow.error((Throwable)((Object)new AssertionError((Object)"Should never be hit, no further steps are allowed after cancel")));

        private Cancel() {
        }

        @Override
        ExecutionFlow<E> apply(ExecutionFlow<E> input) {
            input.cancel();
            return ERR;
        }
    }

    private static final class Map<I, O>
    extends Step<I, O> {
        private final Function<? super I, ? extends O> transformer;

        private Map(Function<? super I, ? extends O> transformer) {
            this.transformer = transformer;
        }

        @Override
        ExecutionFlow<O> apply(ExecutionFlow<I> executionFlow) {
            try {
                return executionFlow.map(this.transformer);
            }
            catch (Exception e) {
                return this.returnError(e);
            }
        }
    }

    private static final class FlatMap<I, O>
    extends Step<I, O> {
        private final Function<? super I, ? extends ExecutionFlow<? extends O>> transformer;

        private FlatMap(Function<? super I, ? extends ExecutionFlow<? extends O>> transformer) {
            this.transformer = transformer;
        }

        @Override
        ExecutionFlow<O> apply(ExecutionFlow<I> executionFlow) {
            try {
                return executionFlow.flatMap(this.transformer);
            }
            catch (Exception e) {
                return this.returnError(e);
            }
        }
    }

    private static final class Then<I, O>
    extends Step<I, O> {
        private final Supplier<? extends ExecutionFlow<? extends O>> transformer;

        private Then(Supplier<? extends ExecutionFlow<? extends O>> transformer) {
            this.transformer = transformer;
        }

        @Override
        ExecutionFlow<O> apply(ExecutionFlow<I> executionFlow) {
            try {
                return executionFlow.then(this.transformer);
            }
            catch (Exception e) {
                return this.returnError(e);
            }
        }
    }

    private static final class OnErrorResume<I>
    extends Step<I, I> {
        private final Function<? super Throwable, ? extends ExecutionFlow<? extends I>> fallback;

        private OnErrorResume(Function<? super Throwable, ? extends ExecutionFlow<? extends I>> fallback) {
            this.fallback = fallback;
        }

        @Override
        ExecutionFlow<I> apply(ExecutionFlow<I> executionFlow) {
            try {
                return executionFlow.onErrorResume(this.fallback);
            }
            catch (Exception e) {
                return this.returnError(e);
            }
        }
    }

    private static final class OnComplete<E>
    extends Step<E, E> {
        private final BiConsumer<? super E, Throwable> consumer;

        public OnComplete(BiConsumer<? super E, Throwable> consumer) {
            this.consumer = consumer;
        }

        @Override
        ExecutionFlow<E> apply(ExecutionFlow<E> executionFlow) {
            try {
                executionFlow.onComplete(this.consumer);
            }
            catch (Exception e) {
                LOG.error("Failed to execute onComplete", (Throwable)e);
            }
            return executionFlow;
        }
    }

    private static final class OnCompleteToFuture<E>
    extends Step<E, E> {
        private final CompletableFuture<E> future;

        public OnCompleteToFuture(CompletableFuture<E> future) {
            this.future = future;
        }

        @Override
        ExecutionFlow<E> apply(ExecutionFlow<E> executionFlow) {
            try {
                executionFlow.completeTo(this.future);
            }
            catch (Exception e) {
                LOG.error("Failed to execute onComplete", (Throwable)e);
            }
            return executionFlow;
        }
    }
}

