/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.serialize;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.serialize.exceptions.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Optional;

public class DefaultStringKeySerializer
implements ObjectSerializer {
    private final ConversionService conversionService;
    private final String cacheName;
    private final Charset charset;

    public DefaultStringKeySerializer(String cacheName, Charset charset, ConversionService conversionService) {
        this.cacheName = cacheName;
        this.charset = charset;
        this.conversionService = conversionService;
    }

    public Optional<byte[]> serialize(Object object) throws SerializationException {
        if (object == null) {
            return Optional.empty();
        }
        return Optional.of(this.toByteArray(object));
    }

    public void serialize(Object object, OutputStream outputStream) throws SerializationException {
        byte[] bytes = this.toByteArray(object);
        try {
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("Error serializing object [" + String.valueOf(object) + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private byte[] toByteArray(Object object) {
        String str = this.cacheName + ":" + this.conversionService.convert(object, String.class).orElse(String.valueOf(object.hashCode()));
        return str.getBytes(this.charset);
    }

    public <T> Optional<T> deserialize(InputStream inputStream, Class<T> requiredType) throws SerializationException {
        throw new UnsupportedOperationException("Hash code based key deserialization not supported");
    }
}

