/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.CompositeBaggage;
import io.micrometer.tracing.otel.bridge.Entry;
import io.micrometer.tracing.otel.bridge.OtelBaggageInScope;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OtelBaggageManager
implements BaggageManager {
    private static final String PROPAGATION_UNLIMITED = "propagation=unlimited";
    private final CurrentTraceContext currentTraceContext;
    private final List<String> remoteFields;
    private final List<String> tagFields;

    public OtelBaggageManager(CurrentTraceContext currentTraceContext, List<String> remoteFields, List<String> tagFields) {
        this.currentTraceContext = currentTraceContext;
        this.remoteFields = remoteFields;
        this.tagFields = tagFields;
    }

    public Map<String, String> getAllBaggage() {
        return this.toMap(this.currentBaggage());
    }

    private Map<String, String> toMap(CompositeBaggage compositeBaggage) {
        HashMap<String, String> baggage = new HashMap<String, String>();
        compositeBaggage.getEntries().forEach(entry -> baggage.put(entry.getKey(), entry.getValue()));
        return baggage;
    }

    public Map<String, String> getAllBaggage(TraceContext traceContext) {
        if (traceContext == null) {
            return this.getAllBaggage();
        }
        return this.toMap(this.baggage((OtelTraceContext)traceContext));
    }

    CompositeBaggage currentBaggage() {
        return this.baggage((OtelTraceContext)this.currentTraceContext.context());
    }

    private CompositeBaggage baggage(OtelTraceContext traceContext) {
        Context context = Context.current();
        ArrayDeque<Context> stack = new ArrayDeque<Context>();
        stack.addFirst(context);
        if (traceContext != null && traceContext.context() != null) {
            stack.addFirst(traceContext.context());
        }
        return new CompositeBaggage(stack);
    }

    public Baggage getBaggage(String name) {
        Entry entry = this.getBaggage(name, this.currentBaggage());
        return this.createNewEntryIfMissing(name, entry);
    }

    Baggage createNewEntryIfMissing(String name, Entry entry) {
        if (entry == null) {
            return this.createBaggage(name);
        }
        return this.otelBaggage(entry);
    }

    private Entry getBaggage(String name, io.opentelemetry.api.baggage.Baggage baggage) {
        return this.entryForName(name, baggage);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        OtelTraceContext context = (OtelTraceContext)traceContext;
        LinkedList<Context> stack = new LinkedList<Context>();
        Context current = Context.current();
        Context traceContextContext = context.context();
        stack.addFirst(current);
        if (!Objects.equals(current, traceContextContext)) {
            stack.addFirst(traceContextContext);
        }
        Context ctx = this.removeFirst(stack);
        Entry entry = null;
        while (ctx != null && entry == null) {
            entry = this.getBaggage(name, io.opentelemetry.api.baggage.Baggage.fromContext((Context)ctx));
            ctx = this.removeFirst(stack);
        }
        if (entry != null) {
            return this.otelBaggage(context, entry);
        }
        return null;
    }

    Entry getEntry(OtelTraceContext traceContext, String name) {
        OtelTraceContext context = traceContext;
        Context ctx = context.context();
        return this.getBaggage(name, io.opentelemetry.api.baggage.Baggage.fromContext((Context)ctx));
    }

    Context removeFirst(Deque<Context> stack) {
        return stack.isEmpty() ? null : stack.removeFirst();
    }

    private Entry entryForName(String name, io.opentelemetry.api.baggage.Baggage baggage) {
        return Entry.fromBaggage(baggage).stream().filter(e -> e.getKey().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private Baggage otelBaggage(Entry entry) {
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    private Baggage otelBaggage(OtelTraceContext otelTraceContext, Entry entry) {
        return new OtelBaggageInScope(this, this.currentTraceContext, otelTraceContext, this.tagFields, entry);
    }

    @Deprecated
    public Baggage createBaggage(String name) {
        return this.createBaggage(name, null);
    }

    @Deprecated
    public Baggage createBaggage(String name, String value) {
        Baggage baggage = this.baggageWithValue(name, value);
        return baggage.set(value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.baggageWithValue(name, value).makeCurrent();
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.baggageWithValue(name, value).makeCurrent(traceContext, value);
    }

    private Baggage baggageWithValue(String name, @Nullable String value) {
        boolean remoteField = this.remoteFields.stream().map(String::toLowerCase).anyMatch(s -> s.equals(name.toLowerCase()));
        BaggageEntryMetadata entryMetadata = BaggageEntryMetadata.create((String)this.propagationString(remoteField));
        Entry entry = new Entry(name, value, entryMetadata);
        return new OtelBaggageInScope(this, this.currentTraceContext, this.tagFields, entry);
    }

    private String propagationString(boolean remoteField) {
        String propagation = "";
        if (remoteField) {
            propagation = PROPAGATION_UNLIMITED;
        }
        return propagation;
    }
}

