/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.brave.bridge;

final class TemporaryBuffers {
    private static final ThreadLocal<char[]> CHAR_ARRAY = new ThreadLocal();

    private TemporaryBuffers() {
    }

    public static char[] chars(int len) {
        char[] buffer = CHAR_ARRAY.get();
        if (buffer == null) {
            buffer = new char[len];
            CHAR_ARRAY.set(buffer);
        } else if (buffer.length < len) {
            buffer = new char[len];
            CHAR_ARRAY.set(buffer);
        }
        return buffer;
    }

    static void clearChars() {
        CHAR_ARRAY.set(null);
    }
}

