/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.orm.jpa;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jpa.HibernateMetrics;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, HibernateJpaAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={EntityManagerFactory.class, SessionFactory.class, MeterRegistry.class})
@Conditional(value={HibernateMetricsConditionalOnBeans.class})
public class HibernateMetricsAutoConfiguration {
    private static final String ENTITY_MANAGER_FACTORY_SUFFIX = "entityManagerFactory";
    private final MeterRegistry registry;

    public HibernateMetricsAutoConfiguration(MeterRegistry registry) {
        this.registry = registry;
    }

    @Autowired
    public void bindEntityManagerFactoriesToRegistry(Map<String, EntityManagerFactory> entityManagerFactories) {
        entityManagerFactories.forEach(this::bindEntityManagerFactoryToRegistry);
    }

    private void bindEntityManagerFactoryToRegistry(String beanName, EntityManagerFactory entityManagerFactory) {
        String entityManagerFactoryName = this.getEntityManagerFactoryName(beanName);
        try {
            SessionFactory sessionFactory = (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
            new HibernateMetrics(sessionFactory, entityManagerFactoryName, Collections.emptyList()).bindTo(this.registry);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    private String getEntityManagerFactoryName(String beanName) {
        if (beanName.length() > ENTITY_MANAGER_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)ENTITY_MANAGER_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - ENTITY_MANAGER_FACTORY_SUFFIX.length());
        }
        return beanName;
    }

    static class HibernateMetricsConditionalOnBeans
    extends AllNestedConditions {
        HibernateMetricsConditionalOnBeans() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={EntityManagerFactory.class})
        static class ConditionalOnEntityManagerFactoryBean {
            ConditionalOnEntityManagerFactoryBean() {
            }
        }

        @ConditionalOnBean(value={MeterRegistry.class})
        static class ConditionalOnMeterRegistryBean {
            ConditionalOnMeterRegistryBean() {
            }
        }
    }
}

