/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleProperties;
import io.micrometer.spring.autoconfigure.export.simple.SimplePropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@EnableConfigurationProperties(value={SimpleProperties.class})
@ConditionalOnMissingBean(value={MeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.simple", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={StringToDurationConverter.class})
public class SimpleMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SimpleConfig simpleRegistryConfig(SimpleProperties props) {
        return new SimplePropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public SimpleMeterRegistry simpleMeterRegistry(SimpleConfig config, Clock clock) {
        return new SimpleMeterRegistry(config, clock);
    }
}

