/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.elastic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.elastic.ElasticProperties;
import io.micrometer.spring.autoconfigure.export.elastic.ElasticPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={ElasticMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.elastic", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ElasticProperties.class})
@Import(value={StringToDurationConverter.class})
public class ElasticMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ElasticConfig elasticConfig(ElasticProperties props) {
        return new ElasticPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public ElasticMeterRegistry elasticMeterRegistry(ElasticConfig config, Clock clock) {
        return new ElasticMeterRegistry(config, clock);
    }
}

