/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;

public interface SignalFxConfig
extends StepRegistryConfig {
    default public String prefix() {
        return "signalfx";
    }

    default public String accessToken() {
        String v = this.get(this.prefix() + ".accessToken");
        if (v == null) {
            throw new MissingRequiredConfigurationException("accessToken must be set to report metrics to SignalFX");
        }
        return v;
    }

    default public String uri() {
        String v = this.get(this.prefix() + ".apiHost");
        return v == null ? "https://ingest.signalfx.com" : v;
    }

    default public String source() {
        String v = this.get(this.prefix() + ".source");
        if (v != null) {
            return v;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            return "unknown";
        }
    }

    default public Duration step() {
        String v = this.get(this.prefix() + ".step");
        return v == null ? Duration.ofSeconds(10L) : Duration.parse(v);
    }
}

