/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm.convention.micrometer;

import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterConvention;
import io.micrometer.core.instrument.binder.SimpleMeterConvention;
import io.micrometer.core.instrument.binder.jvm.convention.JvmMemoryMeterConventions;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;

public class MicrometerJvmMemoryMeterConventions
implements JvmMemoryMeterConventions {
    protected final Tags extraTags;

    public MicrometerJvmMemoryMeterConventions() {
        this(Tags.empty());
    }

    public MicrometerJvmMemoryMeterConventions(Tags extraTags) {
        this.extraTags = extraTags;
    }

    protected Tags getCommonTags(MemoryPoolMXBean memoryPoolBean) {
        return this.extraTags.and(Tags.of("id", memoryPoolBean.getName(), "area", MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap"));
    }

    @Override
    public MeterConvention<MemoryPoolMXBean> getMemoryUsedConvention() {
        return new SimpleMeterConvention<MemoryPoolMXBean>("jvm.memory.used", this::getCommonTags);
    }

    @Override
    public MeterConvention<MemoryPoolMXBean> getMemoryCommittedConvention() {
        return new SimpleMeterConvention<MemoryPoolMXBean>("jvm.memory.committed", this::getCommonTags);
    }

    @Override
    public MeterConvention<MemoryPoolMXBean> getMemoryMaxConvention() {
        return new SimpleMeterConvention<MemoryPoolMXBean>("jvm.memory.max", this::getCommonTags);
    }
}

