/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class JsonValueListOutput<K, V>
extends CommandOutput<K, V, List<JsonValue>> {
    private boolean initialized;
    private final JsonParser parser;

    public JsonValueListOutput(RedisCodec<K, V> codec, JsonParser theParser) {
        super(codec, Collections.emptyList());
        this.parser = theParser;
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (!this.initialized) {
            this.multi(1);
        }
        ByteBuffer fetched = null;
        if (bytes != null) {
            fetched = ByteBuffer.allocate(bytes.remaining());
            fetched.put(bytes);
            fetched.flip();
        }
        ((List)this.output).add(this.parser.loadJsonValue(fetched));
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }
}

