/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.internal.LettuceAssert;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;

public class SslOptions {
    public static final SslProvider DEFAULT_SSL_PROVIDER = SslProvider.JDK;
    private final SslProvider sslProvider;
    private final URL keystore;
    private final char[] keystorePassword;
    private final URL truststore;
    private final char[] truststorePassword;

    protected SslOptions(Builder builder) {
        this.sslProvider = builder.sslProvider;
        this.keystore = builder.keystore;
        this.keystorePassword = builder.keystorePassword;
        this.truststore = builder.truststore;
        this.truststorePassword = builder.truststorePassword;
    }

    protected SslOptions(SslOptions original) {
        this.sslProvider = original.getSslProvider();
        this.keystore = original.keystore;
        this.keystorePassword = original.keystorePassword;
        this.truststore = original.getTruststore();
        this.truststorePassword = original.getTruststorePassword();
    }

    public static SslOptions copyOf(SslOptions options) {
        return new SslOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SslOptions create() {
        return SslOptions.builder().build();
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public URL getKeystore() {
        return this.keystore;
    }

    public char[] getKeystorePassword() {
        return Arrays.copyOf(this.keystorePassword, this.keystorePassword.length);
    }

    public URL getTruststore() {
        return this.truststore;
    }

    public char[] getTruststorePassword() {
        return Arrays.copyOf(this.truststorePassword, this.truststorePassword.length);
    }

    public static class Builder {
        private SslProvider sslProvider = DEFAULT_SSL_PROVIDER;
        private URL keystore;
        private char[] keystorePassword = new char[0];
        private URL truststore;
        private char[] truststorePassword = new char[0];

        private Builder() {
        }

        public Builder jdkSslProvider() {
            return this.sslProvider(SslProvider.JDK);
        }

        public Builder openSslProvider() {
            return this.sslProvider(SslProvider.OPENSSL);
        }

        private Builder sslProvider(SslProvider sslProvider) {
            if (sslProvider == SslProvider.OPENSSL && !OpenSsl.isAvailable()) {
                throw new IllegalStateException("OpenSSL SSL Provider is not available");
            }
            this.sslProvider = sslProvider;
            return this;
        }

        public Builder keystore(File keystore) {
            return this.keystore(keystore, new char[0]);
        }

        public Builder keystore(File keystore, char[] keystorePassword) {
            LettuceAssert.notNull(keystore, "Keystore must not be null");
            LettuceAssert.isTrue(keystore.exists(), String.format("Keystore file %s does not exist", this.truststore));
            LettuceAssert.isTrue(keystore.isFile(), String.format("Keystore file %s is not a file", this.truststore));
            try {
                return this.keystore(keystore.toURI().toURL(), keystorePassword);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder keystore(URL keystore) {
            return this.keystore(keystore, new char[0]);
        }

        public Builder keystore(URL keystore, char[] keystorePassword) {
            LettuceAssert.notNull(keystore, "Keystore must not be null");
            this.keystore = keystore;
            this.keystorePassword = keystorePassword != null ? Arrays.copyOf(keystorePassword, keystorePassword.length) : new char[0];
            return this;
        }

        public Builder truststore(File truststore) {
            return this.truststore(truststore, "");
        }

        public Builder truststore(File truststore, String truststorePassword) {
            LettuceAssert.notNull(truststore, "Truststore must not be null");
            LettuceAssert.isTrue(truststore.exists(), String.format("Truststore file %s does not exist", truststore));
            LettuceAssert.isTrue(truststore.isFile(), String.format("Truststore file %s is not a file", truststore));
            try {
                return this.truststore(truststore.toURI().toURL(), truststorePassword);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public Builder truststore(URL truststore) {
            return this.truststore(truststore, "");
        }

        public Builder truststore(URL truststore, String truststorePassword) {
            LettuceAssert.notNull(truststore, "Truststore must not be null");
            this.truststore = truststore;
            this.truststorePassword = LettuceStrings.isNotEmpty(truststorePassword) ? truststorePassword.toCharArray() : new char[0];
            return this;
        }

        public SslOptions build() {
            return new SslOptions(this);
        }
    }
}

