/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodSchedulingContextSpec describes where resources for the Pod are needed.")
public class V1alpha2PodSchedulingContextSpec {
    public static final String SERIALIZED_NAME_POTENTIAL_NODES = "potentialNodes";
    @SerializedName(value="potentialNodes")
    private List<String> potentialNodes = null;
    public static final String SERIALIZED_NAME_SELECTED_NODE = "selectedNode";
    @SerializedName(value="selectedNode")
    private String selectedNode;

    public V1alpha2PodSchedulingContextSpec potentialNodes(List<String> potentialNodes) {
        this.potentialNodes = potentialNodes;
        return this;
    }

    public V1alpha2PodSchedulingContextSpec addPotentialNodesItem(String potentialNodesItem) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(potentialNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PotentialNodes lists nodes where the Pod might be able to run.  The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.")
    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    public void setPotentialNodes(List<String> potentialNodes) {
        this.potentialNodes = potentialNodes;
    }

    public V1alpha2PodSchedulingContextSpec selectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use \"WaitForFirstConsumer\" allocation is to be attempted.")
    public String getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2PodSchedulingContextSpec v1alpha2PodSchedulingContextSpec = (V1alpha2PodSchedulingContextSpec)o;
        return Objects.equals(this.potentialNodes, v1alpha2PodSchedulingContextSpec.potentialNodes) && Objects.equals(this.selectedNode, v1alpha2PodSchedulingContextSpec.selectedNode);
    }

    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2PodSchedulingContextSpec {\n");
        sb.append("    potentialNodes: ").append(this.toIndentedString(this.potentialNodes)).append("\n");
        sb.append("    selectedNode: ").append(this.toIndentedString(this.selectedNode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

