/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.call.UnsupportedContentTypeException;
import io.ktor.client.engine.UtilsKt;
import io.ktor.client.engine.apache.ApacheEngineConfig;
import io.ktor.client.engine.apache.ApacheHttpRequestKt;
import io.ktor.client.engine.apache.ApacheRequestProducerKt;
import io.ktor.client.engine.apache.InterestControllerHolder;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.Headers;
import io.ktor.http.HttpMethod;
import io.ktor.http.HttpMethodKt;
import io.ktor.http.URLUtilsJvmKt;
import io.ktor.http.Url;
import io.ktor.http.content.OutgoingContent;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.ByteReadChannelOperations_jvmKt;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.WriterScope;
import java.net.URI;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.JobKt;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001b\u0010#\u001a\u00020\u001b2\n\u0010\"\u001a\u00060 j\u0002`!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b+\u0010\u001fJ\u000f\u0010-\u001a\u00020,H\u0002\u00a2\u0006\u0004\b-\u0010.R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010/\u001a\u0004\b0\u00101R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00102R\u0014\u00103\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00108\u001a\u0002078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010;\u001a\u00020:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u00078\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lio/ktor/client/engine/apache/ApacheRequestProducer;", "Lorg/apache/http/nio/protocol/HttpAsyncRequestProducer;", "Lkotlinx/coroutines/CoroutineScope;", "Lio/ktor/client/request/HttpRequestData;", "requestData", "Lio/ktor/client/engine/apache/ApacheEngineConfig;", "config", "Lkotlin/coroutines/CoroutineContext;", "callContext", "<init>", "(Lio/ktor/client/request/HttpRequestData;Lio/ktor/client/engine/apache/ApacheEngineConfig;Lkotlin/coroutines/CoroutineContext;)V", "Lio/ktor/http/content/OutgoingContent;", "body", "Lio/ktor/utils/io/ByteReadChannel;", "getChannel", "(Lkotlin/coroutines/CoroutineContext;Lio/ktor/http/content/OutgoingContent;)Lio/ktor/utils/io/ByteReadChannel;", "", "isRepeatable", "()Z", "Lorg/apache/http/HttpHost;", "getTarget", "()Lorg/apache/http/HttpHost;", "Lorg/apache/http/HttpRequest;", "generateRequest", "()Lorg/apache/http/HttpRequest;", "Lorg/apache/http/protocol/HttpContext;", "context", "", "requestCompleted", "(Lorg/apache/http/protocol/HttpContext;)V", "resetRequest", "()V", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cause", "failed", "(Ljava/lang/Exception;)V", "Lorg/apache/http/nio/ContentEncoder;", "encoder", "Lorg/apache/http/nio/IOControl;", "ioctrl", "produceContent", "(Lorg/apache/http/nio/ContentEncoder;Lorg/apache/http/nio/IOControl;)V", "close", "Lorg/apache/http/client/methods/HttpUriRequest;", "setupRequest", "()Lorg/apache/http/client/methods/HttpUriRequest;", "Lio/ktor/client/request/HttpRequestData;", "getRequestData", "()Lio/ktor/client/request/HttpRequestData;", "Lio/ktor/client/engine/apache/ApacheEngineConfig;", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "host", "Lorg/apache/http/HttpHost;", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "interestController", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "Lkotlinx/coroutines/CompletableJob;", "producerJob", "Lkotlinx/coroutines/CompletableJob;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "channel", "Lio/ktor/utils/io/ByteReadChannel;", "ktor-client-apache"})
@SourceDebugExtension(value={"SMAP\nApacheRequestProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApacheRequestProducer.kt\nio/ktor/client/engine/apache/ApacheRequestProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class ApacheRequestProducer
implements HttpAsyncRequestProducer,
CoroutineScope {
    @NotNull
    private final HttpRequestData requestData;
    @NotNull
    private final ApacheEngineConfig config;
    @NotNull
    private final HttpUriRequest request;
    @NotNull
    private final HttpHost host;
    @NotNull
    private final InterestControllerHolder interestController;
    @NotNull
    private final CompletableJob producerJob;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final ByteReadChannel channel;

    public ApacheRequestProducer(@NotNull HttpRequestData requestData, @NotNull ApacheEngineConfig config, @NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this.requestData = requestData;
        this.config = config;
        this.request = this.setupRequest();
        HttpHost httpHost = URIUtils.extractHost((URI)this.request.getURI());
        if (httpHost == null) {
            throw new IllegalArgumentException("Cannot extract host from URL " + this.request.getURI());
        }
        this.host = httpHost;
        this.interestController = new InterestControllerHolder();
        this.producerJob = JobKt.Job$default(null, (int)1, null);
        this.coroutineContext = callContext.plus((CoroutineContext)this.producerJob);
        this.channel = this.getChannel(callContext, this.requestData.getBody());
        this.producerJob.invokeOnCompletion(arg_0 -> ApacheRequestProducer._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final HttpRequestData getRequestData() {
        return this.requestData;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final ByteReadChannel getChannel(CoroutineContext callContext, OutgoingContent body) {
        ByteReadChannel byteReadChannel;
        OutgoingContent outgoingContent = body;
        if (outgoingContent instanceof OutgoingContent.ByteArrayContent) {
            byteReadChannel = ByteChannelCtorKt.ByteReadChannel$default((byte[])((OutgoingContent.ByteArrayContent)body).bytes(), (int)0, (int)0, (int)6, null);
        } else {
            if (outgoingContent instanceof OutgoingContent.ProtocolUpgrade) {
                throw new UnsupportedContentTypeException(body);
            }
            if (outgoingContent instanceof OutgoingContent.NoContent) {
                byteReadChannel = ByteReadChannel.Companion.getEmpty();
            } else if (outgoingContent instanceof OutgoingContent.ReadChannelContent) {
                byteReadChannel = ((OutgoingContent.ReadChannelContent)body).readFrom();
            } else if (outgoingContent instanceof OutgoingContent.WriteChannelContent) {
                byteReadChannel = ByteWriteChannelOperationsKt.writer((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)callContext, (boolean)true, (Function2)((Function2)new Function2<WriterScope, Continuation<? super Unit>, Object>(body, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ OutgoingContent $body;
                    {
                        this.$body = $body;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                WriterScope $this$writer = (WriterScope)this.L$0;
                                this.label = 1;
                                Object object3 = ((OutgoingContent.WriteChannelContent)this.$body).writeTo($this$writer.getChannel(), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        Function2<WriterScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    public final Object invoke(WriterScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })).getChannel();
            } else if (outgoingContent instanceof OutgoingContent.ContentWrapper) {
                byteReadChannel = this.getChannel(callContext, ((OutgoingContent.ContentWrapper)body).delegate());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byteReadChannel;
    }

    public boolean isRepeatable() {
        return true;
    }

    @NotNull
    public HttpHost getTarget() {
        return this.host;
    }

    @NotNull
    public HttpRequest generateRequest() {
        return (HttpRequest)this.request;
    }

    public void requestCompleted(@NotNull HttpContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public void resetRequest() {
    }

    public void failed(@NotNull Exception cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Exception mappedCause = ApacheHttpRequestKt.mapCause(cause, this.requestData);
        this.channel.cancel((Throwable)mappedCause);
        this.producerJob.completeExceptionally((Throwable)mappedCause);
    }

    public void produceContent(@NotNull ContentEncoder encoder, @NotNull IOControl ioctrl) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)ioctrl, (String)"ioctrl");
        if (this.interestController.getOutputSuspended()) {
            return;
        }
        int result = 0;
        while ((result = ByteReadChannelOperations_jvmKt.readAvailable((ByteReadChannel)this.channel, arg_0 -> ApacheRequestProducer.produceContent$lambda$1(encoder, arg_0))) > 0) {
        }
        if (this.channel.isClosedForRead()) {
            Throwable throwable = this.channel.getClosedCause();
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
            encoder.complete();
            return;
        }
        if (result == -1) {
            this.interestController.suspendOutput(ioctrl);
            BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ApacheRequestProducer this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = ByteReadChannel.DefaultImpls.awaitContent$default((ByteReadChannel)ApacheRequestProducer.access$getChannel$p(this.this$0), (int)0, (Continuation)((Continuation)this), (int)1, null);
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                ((Boolean)v0).booleanValue();
                            }
                            catch (Throwable var2_3) {
                                throw var2_3;
                            }
                            finally {
                                ApacheRequestProducer.access$getInterestController$p(this.this$0).resumeOutputIfPossible();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public void close() {
        ByteReadChannelKt.cancel((ByteReadChannel)this.channel);
        this.producerJob.complete();
    }

    /*
     * WARNING - void declaration
     */
    private final HttpUriRequest setupRequest() {
        boolean hasContent;
        HttpRequestData $this$setupRequest_u24lambda_u246 = this.requestData;
        boolean bl = false;
        RequestBuilder requestBuilder = RequestBuilder.create((String)$this$setupRequest_u24lambda_u246.getMethod().getValue());
        Intrinsics.checkNotNull((Object)requestBuilder);
        RequestBuilder builder = requestBuilder;
        builder.setUri(URLUtilsJvmKt.toURI((Url)$this$setupRequest_u24lambda_u246.getUrl()));
        OutgoingContent content = this.requestData.getBody();
        Ref.ObjectRef length = new Ref.ObjectRef();
        Ref.ObjectRef type = new Ref.ObjectRef();
        UtilsKt.mergeHeaders((Headers)$this$setupRequest_u24lambda_u246.getHeaders(), (OutgoingContent)content, (arg_0, arg_1) -> ApacheRequestProducer.setupRequest$lambda$6$lambda$3(length, type, builder, arg_0, arg_1));
        boolean bl2 = hasContent = !($this$setupRequest_u24lambda_u246.getBody() instanceof OutgoingContent.NoContent);
        if (HttpMethodKt.getSupportsRequestBody((HttpMethod)$this$setupRequest_u24lambda_u246.getMethod()) || hasContent) {
            void $this$setupRequest_u24lambda_u246_u24lambda_u244;
            BasicHttpEntity basicHttpEntity;
            BasicHttpEntity basicHttpEntity2 = basicHttpEntity = new BasicHttpEntity();
            RequestBuilder requestBuilder2 = builder;
            boolean bl3 = false;
            String lengthResult = (String)length.element;
            CharSequence charSequence = lengthResult;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                $this$setupRequest_u24lambda_u246_u24lambda_u244.setChunked(true);
            } else {
                $this$setupRequest_u24lambda_u246_u24lambda_u244.setContentLength(Long.parseLong(lengthResult));
            }
            $this$setupRequest_u24lambda_u246_u24lambda_u244.setContentType((String)type.element);
            requestBuilder2.setEntity((HttpEntity)basicHttpEntity);
        }
        ApacheEngineConfig $this$setupRequest_u24lambda_u246_u24lambda_u245 = this.config;
        boolean bl4 = false;
        Function1<RequestConfig.Builder, RequestConfig.Builder> function1 = $this$setupRequest_u24lambda_u246_u24lambda_u245.getCustomRequest();
        RequestConfig.Builder builder2 = RequestConfig.custom().setRedirectsEnabled($this$setupRequest_u24lambda_u246_u24lambda_u245.getFollowRedirects()).setSocketTimeout($this$setupRequest_u24lambda_u246_u24lambda_u245.getSocketTimeout()).setConnectTimeout($this$setupRequest_u24lambda_u246_u24lambda_u245.getConnectTimeout()).setConnectionRequestTimeout($this$setupRequest_u24lambda_u246_u24lambda_u245.getConnectionRequestTimeout());
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setConnectionRequestTimeout(...)");
        builder.setConfig(ApacheRequestProducerKt.access$setupTimeoutAttributes((RequestConfig.Builder)function1.invoke((Object)builder2), this.requestData).build());
        HttpUriRequest httpUriRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpUriRequest, (String)"build(...)");
        return httpUriRequest;
    }

    private static final Unit _init_$lambda$0(ApacheRequestProducer this$0, Throwable cause) {
        this$0.channel.cancel(cause);
        return Unit.INSTANCE;
    }

    private static final int produceContent$lambda$1(ContentEncoder $encoder, ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return $encoder.write(buffer);
    }

    private static final Unit setupRequest$lambda$6$lambda$3(Ref.ObjectRef $length, Ref.ObjectRef $type, RequestBuilder $builder, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = key;
        if (Intrinsics.areEqual((Object)string, (Object)"Content-Length")) {
            $length.element = value;
        } else if (Intrinsics.areEqual((Object)string, (Object)"Content-Type")) {
            $type.element = value;
        } else {
            $builder.addHeader(key, value);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ByteReadChannel access$getChannel$p(ApacheRequestProducer $this) {
        return $this.channel;
    }

    public static final /* synthetic */ InterestControllerHolder access$getInterestController$p(ApacheRequestProducer $this) {
        return $this.interestController;
    }
}

