/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.util.FilteredLog;
import hudson.model.TaskListener;
import io.jenkins.plugins.util.PluginLogger;
import java.util.List;

public class LogHandler {
    private final PluginLogger errorLogger;
    private final PluginLogger infoLogger;
    private int infoPosition;
    private int errorPosition;

    public LogHandler(TaskListener listener, String name) {
        this(listener, name, 0, 0);
    }

    public LogHandler(TaskListener listener, String name, FilteredLog logger) {
        this(listener, name, logger.getInfoMessages().size(), logger.getErrorMessages().size());
    }

    private LogHandler(TaskListener listener, String name, int infoPosition, int errorPosition) {
        this.infoLogger = this.createLogger(listener, name);
        this.errorLogger = this.createErrorLogger(listener, name);
        this.infoPosition = infoPosition;
        this.errorPosition = errorPosition;
    }

    private PluginLogger createErrorLogger(TaskListener listener, String name) {
        return this.createLogger(listener, String.format("[%s] [-ERROR-]", name));
    }

    private PluginLogger createLogger(TaskListener listener, String name) {
        return new PluginLogger(listener.getLogger(), name);
    }

    public void log(FilteredLog logger) {
        this.logErrorMessages(logger);
        this.logInfoMessages(logger);
    }

    @FormatMethod
    public void log(String format, Object ... args) {
        this.infoLogger.log(format, args);
    }

    private void logErrorMessages(FilteredLog logger) {
        List<String> errorMessages = logger.getErrorMessages();
        if (this.errorPosition < errorMessages.size()) {
            this.errorLogger.logEachLine(errorMessages.subList(this.errorPosition, errorMessages.size()));
            this.errorPosition = errorMessages.size();
        }
    }

    private void logInfoMessages(FilteredLog logger) {
        List<String> infoMessages = logger.getInfoMessages();
        if (this.infoPosition < infoMessages.size()) {
            this.infoLogger.logEachLine(infoMessages.subList(this.infoPosition, infoMessages.size()));
            this.infoPosition = infoMessages.size();
        }
    }
}

