/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import hudson.model.Run;
import io.jenkins.plugins.util.BuildAction;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class ActionSelector<T extends BuildAction<?>>
implements Function<Run<?, ?>, Optional<T>> {
    private final Class<T> actionType;
    private final Predicate<? super T> predicate;

    public ActionSelector(Class<T> actionType) {
        this(actionType, action -> true);
    }

    public ActionSelector(Class<T> actionType, Predicate<? super T> predicate) {
        this.actionType = actionType;
        this.predicate = predicate;
    }

    @Override
    public Optional<T> apply(Run<?, ?> baseline) {
        for (Run run = baseline; run != null; run = run.getPreviousBuild()) {
            Optional<T> action = run.getActions(this.actionType).stream().filter(this.predicate).findAny();
            if (!action.isPresent()) continue;
            return action;
        }
        return Optional.empty();
    }

    public final Optional<T> findFirst(Run<?, ?> baseline) {
        return this.apply(baseline);
    }
}

